/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.util;

import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.frontend.taglib.util.TagAccessor;
import com.liferay.frontend.taglib.util.internal.NPMResolverRef;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.util.OutputData;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TagResourceHandler {
    private static final EnumMap<Position, String> _webKeysEnumMap = new EnumMap<Position, String>(Position.class){
        {
            this.put(Position.BOTTOM, "PAGE_BODY_BOTTOM");
            this.put(Position.TOP, "PAGE_TOP");
        }
    };
    private final Bundle _bundle;
    private final Log _log;
    private final AtomicLong _nextKey = new AtomicLong();
    private final TagAccessor _tagAccessor;
    private final String _webContextPath;

    public TagResourceHandler(Class<?> tagClass, TagAccessor tagAccessor) {
        this._tagAccessor = tagAccessor;
        this._bundle = FrameworkUtil.getBundle(tagClass);
        this._log = LogFactoryUtil.getLog(tagClass);
        Dictionary headers = this._bundle.getHeaders("");
        this._webContextPath = (String)headers.get("Web-ContextPath");
    }

    public void outputBundleStyleSheet(String bundleCssPath) {
        StringBundler sb = new StringBundler(6);
        sb.append("<link data-senna-track=\"temporary\" href=\"");
        sb.append(PortalUtil.getPathModule());
        sb.append(this._webContextPath);
        sb.append("/");
        sb.append(bundleCssPath);
        sb.append("\" rel=\"stylesheet\">");
        this.outputResource(Position.TOP, sb.toString());
    }

    public void outputNPMResource(String npmResourcePath) {
        try (NPMResolverRef npmResolverRef = new NPMResolverRef(this._tagAccessor);){
            NPMResolver npmResolver = npmResolverRef.getNPMResolver();
            String resourcePath = npmResolver.resolveModuleName(npmResourcePath);
            URL url = this._bundle.getEntry("META-INF/resources/node_modules/" + resourcePath);
            this.outputResource(Position.BOTTOM, StringUtil.read((InputStream)url.openStream()));
        }
        catch (Exception exception) {
            this._log.error((Object)("Unable to output NPM resource " + npmResourcePath), (Throwable)exception);
        }
    }

    public void outputNPMStyleSheet(String npmCssPath) {
        try (NPMResolverRef npmResolverRef = new NPMResolverRef(this._tagAccessor);){
            NPMResolver npmResolver = npmResolverRef.getNPMResolver();
            String cssPath = npmResolver.resolveModuleName(npmCssPath);
            StringBundler sb = new StringBundler(6);
            sb.append("<link href=\"");
            sb.append(PortalUtil.getPathModule());
            sb.append(this._webContextPath);
            sb.append("/node_modules/");
            sb.append(cssPath);
            sb.append("\" rel=\"stylesheet\">");
            this.outputResource(Position.TOP, sb.toString());
        }
        catch (Exception exception) {
            this._log.error((Object)("Unable to output NPM style sheet " + npmCssPath), (Throwable)exception);
        }
    }

    public void outputResource(Position position, String html) {
        HttpServletRequest httpServletRequest = this._getRequest();
        boolean xPjax = GetterUtil.getBoolean((String)httpServletRequest.getHeader("X-PJAX"));
        ThemeDisplay themeDisplay = this._getThemeDisplay();
        if (themeDisplay.isIsolated() || themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive() || xPjax) {
            try {
                PageContext pageContext = this._tagAccessor.getPageContext();
                JspWriter jspWriter = pageContext.getOut();
                jspWriter.write(html);
            }
            catch (IOException ioException) {
                this._log.error((Object)"Unable to output resource", (Throwable)ioException);
            }
        } else {
            OutputData outputData = this._getOutputData();
            Long key = this._nextKey.getAndIncrement();
            outputData.setDataSB(key.toString(), _webKeysEnumMap.get((Object)position), new StringBundler(html));
        }
    }

    private OutputData _getOutputData() {
        HttpServletRequest httpServletRequest = this._getRequest();
        OutputData outputData = (OutputData)httpServletRequest.getAttribute("LIFERAY_SHARED_OUTPUT_DATA");
        if (outputData == null) {
            outputData = new OutputData();
            httpServletRequest.setAttribute("LIFERAY_SHARED_OUTPUT_DATA", (Object)outputData);
        }
        return outputData;
    }

    private HttpServletRequest _getRequest() {
        return this._tagAccessor.getRequest();
    }

    private ThemeDisplay _getThemeDisplay() {
        HttpServletRequest servletRequest = this._getRequest();
        return (ThemeDisplay)servletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public static enum Position {
        BOTTOM,
        TOP;

    }
}

