/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.servlet.taglib;

import com.liferay.frontend.taglib.servlet.taglib.VerticalCardTag;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.taglib.util.LexiconUtil;
import com.liferay.users.admin.configuration.UserFileUploadsConfiguration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class UserVerticalCardTag
extends VerticalCardTag {
    private static final Log _log = LogFactoryUtil.getLog(UserVerticalCardTag.class);
    private long _userId;

    public void setUserId(long userId) {
        this._userId = userId;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._userId = 0L;
    }

    @Override
    protected String getPage() {
        return "/card/user_vertical_card/page.jsp";
    }

    protected User getUser() {
        return UserLocalServiceUtil.fetchUser((long)this._userId);
    }

    protected boolean isCleanUpSetAttributes() {
        return true;
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        User user;
        block4: {
            super.setAttributes(request);
            user = this.getUser();
            request.setAttribute("liferay-frontend:card:colorCssClass", (Object)LexiconUtil.getUserColorCssClass((User)user));
            if (!(user == null || user.getPortraitId() <= 0L && this._isImageDefaultUseInitials(user))) {
                ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                try {
                    request.setAttribute("liferay-frontend:card:portraitURL", (Object)user.getPortraitURL(themeDisplay));
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)pe, (Throwable)pe);
                }
            }
        }
        String initials = "";
        if (user != null) {
            initials = user.getInitials();
        }
        request.setAttribute("liferay-frontend:card:userInitials", (Object)initials);
    }

    private boolean _isImageDefaultUseInitials(User user) {
        boolean imageDefaultUseInitials = true;
        try {
            UserFileUploadsConfiguration userFileUploadsConfiguration = (UserFileUploadsConfiguration)ConfigurationProviderUtil.getSystemConfiguration(UserFileUploadsConfiguration.class);
            imageDefaultUseInitials = userFileUploadsConfiguration.imageDefaultUseInitials();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if ("image".equals(LanguageUtil.get((Locale)user.getLocale(), (String)"lang.user.default.portrait", (String)"initials"))) {
            imageDefaultUseInitials = false;
        }
        return imageDefaultUseInitials;
    }
}

