/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.servlet.taglib.soy;

import com.liferay.frontend.taglib.soy.servlet.taglib.ComponentRendererTag;
import com.liferay.portal.kernel.diff.DiffVersion;
import com.liferay.portal.kernel.diff.DiffVersionsInfo;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DiffVersionComparatorTag
extends ComponentRendererTag {
    private static final String[] _LANGUAGE_KEYS = new String[]{"added", "deleted", "first-version", "format-changes", "last-version", "there-are-no-results", "you-are-comparing-these-versions"};
    private static final Log _log = LogFactoryUtil.getLog(DiffVersionComparatorTag.class);
    private Set<Locale> _availableLocales;
    private DiffVersionsInfo _diffVersionsInfo;
    private String _languageId;
    private PortletURL _portletURL;
    private PortletURL _resourceURL;
    private double _sourceVersion;
    private double _targetVersion;

    public JSONObject createDiffVersionJSONObject(DiffVersion diffVersion, PortletURL sourceURL, PortletURL targetURL) throws PortalException {
        JSONObject diffVersionJSONObject = JSONFactoryUtil.createJSONObject();
        Date modifiedDate = diffVersion.getModifiedDate();
        String timeDescription = LanguageUtil.getTimeDescription((HttpServletRequest)this.request, (long)(System.currentTimeMillis() - modifiedDate.getTime()), (boolean)true);
        diffVersionJSONObject.put("displayDate", LanguageUtil.format((HttpServletRequest)this.request, (String)"x-ago", (Object)timeDescription, (boolean)false));
        diffVersionJSONObject.put("inRange", diffVersion.getVersion() > this._sourceVersion && diffVersion.getVersion() <= this._targetVersion);
        String diffVersionString = String.valueOf(diffVersion.getVersion());
        diffVersionJSONObject.put("label", LanguageUtil.format((HttpServletRequest)this.request, (String)"version-x", (Object)diffVersionString));
        sourceURL.setParameter("sourceVersion", diffVersionString);
        diffVersionJSONObject.put("sourceURL", sourceURL.toString());
        targetURL.setParameter("targetVersion", diffVersionString);
        diffVersionJSONObject.put("targetURL", targetURL.toString());
        User user = UserLocalServiceUtil.getUser((long)diffVersion.getUserId());
        diffVersionJSONObject.put("userInitials", user.getInitials());
        diffVersionJSONObject.put("userName", user.getFullName());
        diffVersionJSONObject.put("version", diffVersionString);
        return diffVersionJSONObject;
    }

    public JSONObject createLanguageKeysJSONObject() {
        JSONObject languageKeysJSONObject = JSONFactoryUtil.createJSONObject();
        for (String languageKey : _LANGUAGE_KEYS) {
            languageKeysJSONObject.put(languageKey, LanguageUtil.get((HttpServletRequest)this.request, (String)languageKey));
        }
        return languageKeysJSONObject;
    }

    public int doStartTag() {
        block5: {
            if (Validator.isNotNull((String)this._languageId)) {
                this._portletURL.setParameter("languageId", this._languageId);
                this._resourceURL.setParameter("languageId", this._languageId);
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            try {
                RenderResponse renderResponse = (RenderResponse)this.request.getAttribute("javax.portlet.response");
                PortletURL sourceURL = PortletURLUtil.clone((PortletURL)this._portletURL, (MimeResponse)renderResponse);
                sourceURL.setParameter("targetVersion", String.valueOf(this._targetVersion));
                PortletURL targetURL = PortletURLUtil.clone((PortletURL)this._portletURL, (MimeResponse)renderResponse);
                targetURL.setParameter("sourceVersion", String.valueOf(this._sourceVersion));
                JSONArray diffVersionsJSONArray = JSONFactoryUtil.createJSONArray();
                int diffVersionsCount = 0;
                for (DiffVersion diffVersion : this._diffVersionsInfo.getDiffVersions()) {
                    JSONObject diffVersionJSONObject = this.createDiffVersionJSONObject(diffVersion, sourceURL, targetURL);
                    if (diffVersionJSONObject.getBoolean("inRange")) {
                        ++diffVersionsCount;
                    }
                    diffVersionsJSONArray.put(diffVersionJSONObject);
                }
                this.putValue("diffVersions", diffVersionsJSONArray);
                this.putValue("diffVersionsCount", diffVersionsCount);
                this.putValue("languageKeys", this.createLanguageKeysJSONObject());
                this.putValue("nextVersion", String.valueOf(this._diffVersionsInfo.getNextVersion()));
                this.putValue("pathThemeImages", themeDisplay.getPathThemeImages());
                PortletResponse portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
                this.putValue("portletNamespace", portletResponse.getNamespace());
                this.putValue("portletURL", this._portletURL.toString());
                this.putValue("previousVersion", String.valueOf(this._diffVersionsInfo.getPreviousVersion()));
                this.putValue("resourceURL", this._resourceURL.toString());
            }
            catch (PortalException | PortletException e) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)e, e);
            }
        }
        this.setTemplateNamespace("liferay.frontend.DiffVersionComparator.render");
        return super.doStartTag();
    }

    public String getModule() {
        return "frontend-taglib/diff_version_comparator/DiffVersionComparator.es";
    }

    public void setAvailableLocales(Set<Locale> availableLocales) {
        this._availableLocales = availableLocales;
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONArray availableLocalesJSONArray = JSONFactoryUtil.createJSONArray();
        for (Locale availableLocale : availableLocales) {
            JSONObject availableLocaleJSONObject = JSONFactoryUtil.createJSONObject();
            availableLocaleJSONObject.put("displayName", availableLocale.getDisplayName(themeDisplay.getLocale()));
            availableLocaleJSONObject.put("languageId", LocaleUtil.toLanguageId((Locale)availableLocale));
            availableLocalesJSONArray.put(availableLocaleJSONObject);
        }
        this.putValue("availableLocales", availableLocalesJSONArray);
    }

    public void setDiffHtmlResults(String diffHtmlResults) {
        this.putHTMLValue("diffHtmlResults", diffHtmlResults);
    }

    public void setDiffVersionsInfo(DiffVersionsInfo diffVersionsInfo) {
        this._diffVersionsInfo = diffVersionsInfo;
    }

    public void setLanguageId(String languageId) {
        this._languageId = languageId;
        this.putValue("languageId", languageId);
    }

    public void setPortletURL(PortletURL portletURL) {
        this._portletURL = portletURL;
    }

    public void setResourceURL(PortletURL resourceURL) {
        this._resourceURL = resourceURL;
    }

    public void setSourceVersion(double sourceVersion) {
        this._sourceVersion = sourceVersion;
        this.putValue("sourceVersion", String.valueOf(sourceVersion));
        this.putValue("sourceVersionLabel", LanguageUtil.format((HttpServletRequest)this.request, (String)"version-x", (Object)sourceVersion));
    }

    public void setTargetVersion(double targetVersion) {
        this._targetVersion = targetVersion;
        this.putValue("targetVersion", String.valueOf(targetVersion));
        this.putValue("targetVersionLabel", LanguageUtil.format((HttpServletRequest)this.request, (String)"version-x", (Object)targetVersion));
    }
}

