Liferay.Loader.define("frontend-taglib@3.1.2/cards_treeview/CardsTreeview.es", ['exports', 'metal-soy/src/Soy', 'frontend-js-web/liferay/compat/treeview/Treeview.es', 'metal/src/metal', 'metal-dom/src/all/dom', 'metal-state/src/all/state', './CardsTreeview.soy'], function (exports, _Soy, _Treeview2, _metal, _dom, _state, _CardsTreeview) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _Soy2 = _interopRequireDefault(_Soy);

	var _Treeview3 = _interopRequireDefault(_Treeview2);

	var _metal2 = _interopRequireDefault(_metal);

	var _dom2 = _interopRequireDefault(_dom);

	var _CardsTreeview2 = _interopRequireDefault(_CardsTreeview);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var CardsTreeview = function (_Treeview) {
		_inherits(CardsTreeview, _Treeview);

		function CardsTreeview() {
			_classCallCheck(this, CardsTreeview);

			return _possibleConstructorReturn(this, (CardsTreeview.__proto__ || Object.getPrototypeOf(CardsTreeview)).apply(this, arguments));
		}

		_createClass(CardsTreeview, [{
			key: 'created',
			value: function created() {
				this.expandSelectedNodesParentNodes_(this.nodes);
				this.addSelectedNodes_(this.nodes);
			}
		}, {
			key: 'addSelectedNodes_',
			value: function addSelectedNodes_(nodes) {
				var _this2 = this;

				nodes.forEach(function (node) {
					if (node.children) {
						_this2.addSelectedNodes_(node.children);
					}

					if (node.selected) {
						_this2.selectNode_(node);
					}
				});
			}
		}, {
			key: 'deselectAll_',
			value: function deselectAll_() {
				for (var i = this.selectedNodes.length - 1; i >= 0; i--) {
					this.selectedNodes[i].selected = false;
					this.selectedNodes.pop();
				}
			}
		}, {
			key: 'deselectNode_',
			value: function deselectNode_(node) {
				node.selected = false;

				this.selectedNodes.splice(this.selectedNodes.indexOf(node), 1);

				this.selectedNodes = this.selectedNodes;
			}
		}, {
			key: 'expandSelectedNodesParentNodes_',
			value: function expandSelectedNodesParentNodes_(nodes) {
				var _this3 = this;

				var expanded = void 0,
				    expandedParent = void 0;

				nodes.forEach(function (node) {
					expanded = node.expanded;

					if (node.selected) {
						expandedParent = true;
					}

					if (node.children) {
						expanded = _this3.expandSelectedNodesParentNodes_(node.children) || expanded;
					}

					node.expanded = expanded;
				}, this);

				return expandedParent;
			}
		}, {
			key: 'focus_',
			value: function focus_(nodeObj) {
				if (nodeObj) {
					this.element.querySelector('[data-treeitemid="' + nodeObj.id + '"] .card').focus();
				}
			}
		}, {
			key: 'focusNextNode_',
			value: function focusNextNode_(node) {
				var path = node.getAttribute('data-treeview-path').split('-');

				var nodeObj = this.getNodeObj(path);

				var nextNodeObj = void 0;

				if (nodeObj.children && nodeObj.expanded) {
					path.push(0);

					nextNodeObj = this.getNodeObj(path);
				} else {
					while (!nextNodeObj && path.length > 0) {
						path[path.length - 1]++;

						nextNodeObj = this.getNodeObj(path);

						path.pop();
					}
				}

				this.focus_(nextNodeObj);
			}
		}, {
			key: 'focusPrevNode_',
			value: function focusPrevNode_(node) {
				var path = node.getAttribute('data-treeview-path').split('-');

				var prevNodeObj = void 0;

				if (path[path.length - 1] === '0') {
					path.pop();

					prevNodeObj = this.getNodeObj(path);
				} else {
					path[path.length - 1]--;

					prevNodeObj = this.getNodeObj(path);

					while (prevNodeObj.children && prevNodeObj.expanded) {
						prevNodeObj = prevNodeObj.children[prevNodeObj.children.length - 1];
					}
				}

				this.focus_(prevNodeObj);
			}
		}, {
			key: 'handleNodeClicked_',
			value: function handleNodeClicked_(event) {
				var path = event.delegateTarget.parentNode.parentNode.parentNode.getAttribute('data-treeview-path').split('-');

				var node = this.getNodeObj(path);

				if (this.multiSelection) {
					if (node.selected) {
						this.deselectNode_(node);
					} else {
						this.selectNode_(node);
					}
				} else {
					if (!node.selected) {
						this.deselectAll_();
						this.selectNode_(node);
					}
				}

				this.nodes = this.nodes;
			}
		}, {
			key: 'handleNodeKeyUp_',
			value: function handleNodeKeyUp_(event) {
				var node = event.delegateTarget.parentNode.parentNode.parentNode;

				if (event.keyCode === 37) {
					this.setNodeExpandedState_(node, { expanded: false });
				} else if (event.keyCode === 38) {
					this.focusPrevNode_(node);
				} else if (event.keyCode === 39) {
					this.setNodeExpandedState_(node, { expanded: true });
				} else if (event.keyCode === 40) {
					this.focusNextNode_(node);
				} else if (event.keyCode === 13 || event.keyCode === 32) {
					this.handleNodeClicked_(event);
				}
			}
		}, {
			key: 'handleNodeTogglerClicked_',
			value: function handleNodeTogglerClicked_(event) {
				this.toggleExpandedState_(event.delegateTarget.parentNode.parentNode.parentNode);
			}
		}, {
			key: 'selectNode_',
			value: function selectNode_(node) {
				node.selected = true;

				this.selectedNodes.push(node);

				this.selectedNodes = this.selectedNodes;
			}
		}, {
			key: 'setNodeExpandedState_',
			value: function setNodeExpandedState_(node, state) {
				var path = node.getAttribute('data-treeview-path').split('-');

				var nodeObj = this.getNodeObj(path);

				nodeObj.expanded = state.expanded;

				this.nodes = this.nodes;
			}
		}]);

		return CardsTreeview;
	}(_Treeview3.default);

	/**
  * CardsTreeview state definition.
  * @type {!Object}
  * @review
  * @static
  */
	CardsTreeview.STATE = {
		/**
   * Enables multiple selection of tree elements
   * @review
   * @type {boolean}
   */
		multiSelection: _state.Config.bool().value(false),

		/**
   * List of selected nodes
   * @review
   * @type {Array.<Object>}
   */
		selectedNodes: _state.Config.array().value([]),

		/**
   * Type of view to render. Accepted values are 'tree' and 'flat'
   * @review
   * @type {String}
   */
		viewType: _state.Config.string().value('tree')
	};

	_Soy2.default.register(CardsTreeview, _CardsTreeview2.default);

	exports.default = CardsTreeview;
});
//# sourceMappingURL=CardsTreeview.es.js.map
