Liferay.Loader.define("frontend-taglib@3.1.2/contextual_sidebar/ContextualSidebar.es", ['exports', 'metal-component/src/all/component', 'metal/src/metal', 'metal-soy/src/Soy', 'metal-state/src/all/state', './ContextualSidebar.soy'], function (exports, _component, _metal, _Soy, _state, _ContextualSidebar) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.ContextualSidebar = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _ContextualSidebar2 = _interopRequireDefault(_ContextualSidebar);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	var _extends = Object.assign || function (target) {
		for (var i = 1; i < arguments.length; i++) {
			var source = arguments[i];

			for (var key in source) {
				if (Object.prototype.hasOwnProperty.call(source, key)) {
					target[key] = source[key];
				}
			}
		}

		return target;
	};

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var ContextualSidebar = function (_Component) {
		_inherits(ContextualSidebar, _Component);

		function ContextualSidebar() {
			_classCallCheck(this, ContextualSidebar);

			return _possibleConstructorReturn(this, (ContextualSidebar.__proto__ || Object.getPrototypeOf(ContextualSidebar)).apply(this, arguments));
		}

		_createClass(ContextualSidebar, [{
			key: 'created',
			value: function created() {
				document.body.classList.add('has-contextual-sidebar');

				this._productMenuToggle = $('.product-menu-toggle');
				this._productMenu = $(this._productMenuToggle.data('target'));

				this._handleOpenProductMenu = this._handleOpenProductMenu.bind(this);

				this._productMenu.on('openStart.lexicon.sidenav', this._handleOpenProductMenu);
			}
		}, {
			key: 'disposed',
			value: function disposed() {
				document.body.classList.remove('has-contextual-sidebar');

				this._productMenu.off('openStart.lexicon.sidenav', this._handleOpenProductMenu);
			}
		}, {
			key: 'prepareStateForRender',
			value: function prepareStateForRender(state) {
				return _extends({}, state, {
					body: _Soy2.default.toIncDom(this.body || ''),
					header: _Soy2.default.toIncDom(this.header || '')
				});
			}
		}, {
			key: 'syncVisible',
			value: function syncVisible() {}
		}, {
			key: 'rendered',
			value: function rendered() {
				if (this.visible) {
					document.body.classList.add('contextual-sidebar-visible');

					this._productMenuToggle.sideNavigation('hide');
				} else {
					document.body.classList.remove('contextual-sidebar-visible');
				}
			}
		}, {
			key: '_handleOpenProductMenu',
			value: function _handleOpenProductMenu() {
				this.emit('hide');
			}
		}]);

		return ContextualSidebar;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	ContextualSidebar.STATE = {

		/**
   * Sidebar body content
   * @default undefined
   * @instance
   * @memberOf ContextualSidebar
   * @review
   * @type {!string}
   */

		body: _state.Config.any().setter(function (body) {
			return (0, _metal.isObject)(body) && !(0, _metal.isFunction)(body) ? body.value.content : body;
		}).required(),

		/**
   * Optional CSS classes added to the sidebar body wrapper
   * @default ''
   * @instance
   * @memberOf ContextualSidebar
   * @review
   * @type {string}
   */

		bodyClasses: _state.Config.string().value(''),

		/**
   * Optional CSS classes added to the sidebar wrapper
   * @default ''
   * @instance
   * @memberOf ContextualSidebar
   * @review
   * @type {string}
   */

		elementClasses: _state.Config.string().value(''),

		/**
   * Sidebar header content
   * @default undefined
   * @instance
   * @memberOf ContextualSidebar
   * @review
   * @type {!string}
   */

		header: _state.Config.any().setter(function (header) {
			return (0, _metal.isObject)(header) && !(0, _metal.isFunction)(header) ? header.value.content : header;
		}).required(),

		/**
   * Optional CSS classes added to the sidebar header wrapper
   * @default ''
   * @instance
   * @memberOf ContextualSidebar
   * @review
   * @type {string}
   */

		headerClasses: _state.Config.string().value(''),

		/**
   * Autogenerated id provided by the template engine
   * @default ''
   * @instance
   * @memberOf ContextualSidebar
   * @review
   * @type {string}
   */

		id: _state.Config.string().value(''),

		/**
   * Allow opening/closing contextual sidebar
   * @default undefined
   * @instance
   * @memberOf ContextualSidebar
   * @review
   * @type {!boolean}
   */

		visible: _state.Config.bool().required(),

		/**
   * Internal property that keeps an existing ProductMenu sidebar synced.
   * @default undefined
   * @instance
   * @memberOf ContextualSidebar
   * @review
   * @type {object}
   */

		_productMenu: _state.Config.internal()
	};

	_Soy2.default.register(ContextualSidebar, _ContextualSidebar2.default);

	exports.ContextualSidebar = ContextualSidebar;
	exports.default = ContextualSidebar;
});
//# sourceMappingURL=ContextualSidebar.es.js.map
