Liferay.Loader.define("frontend-taglib@3.1.2/diff_version_comparator/DiffVersionComparator.es", ['exports', 'metal-ajax/src/Ajax', 'metal-component/src/all/component', 'metal-soy/src/Soy', 'metal-state/src/all/state', 'metal-structs/src/all/structs', 'metal/src/metal', './DiffVersionComparator.soy'], function (exports, _Ajax, _component, _Soy, _state, _structs, _metal, _DiffVersionComparator) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.DiffVersionComparator = undefined;

	var _Ajax2 = _interopRequireDefault(_Ajax);

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _DiffVersionComparator2 = _interopRequireDefault(_DiffVersionComparator);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	var _extends = Object.assign || function (target) {
		for (var i = 1; i < arguments.length; i++) {
			var source = arguments[i];

			for (var key in source) {
				if (Object.prototype.hasOwnProperty.call(source, key)) {
					target[key] = source[key];
				}
			}
		}

		return target;
	};

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var DiffVersionComparator = function (_Component) {
		_inherits(DiffVersionComparator, _Component);

		function DiffVersionComparator() {
			_classCallCheck(this, DiffVersionComparator);

			return _possibleConstructorReturn(this, (DiffVersionComparator.__proto__ || Object.getPrototypeOf(DiffVersionComparator)).apply(this, arguments));
		}

		_createClass(DiffVersionComparator, [{
			key: 'findDiffVersion_',
			value: function findDiffVersion_(version) {
				return this.diffVersions.find(function (diffVersion) {
					return diffVersion.version === version;
				});
			}
		}, {
			key: 'handleCloseFilterClick_',
			value: function handleCloseFilterClick_(event) {
				this.selectedVersion = null;

				this.loadDiffHtmlResults_(this.targetVersion);
			}
		}, {
			key: 'handleLanguageChange_',
			value: function handleLanguageChange_() {
				submitForm(this.refs.form);
			}
		}, {
			key: 'handleSearchChange_',
			value: function handleSearchChange_(event) {
				var query = event.target.value.toLowerCase();

				var resultsLength = 0;

				var diffVersions = this.diffVersions.map(function (diffVersion) {
					var label = diffVersion.label,
					    userName = diffVersion.userName;


					var hidden = label.toLowerCase().indexOf(query) === -1 && userName.toLowerCase().indexOf(query) === -1;

					if (!hidden) {
						resultsLength++;
					}

					return _extends({}, diffVersion, {
						hidden: hidden
					});
				});

				this.diffVersions = diffVersions;
				this.resultsLength = resultsLength;
			}
		}, {
			key: 'handleVersionItemClick_',
			value: function handleVersionItemClick_(event) {
				var targetVersion = event.delegateTarget.getAttribute('data-version');

				this.selectedVersion = this.findDiffVersion_(targetVersion);

				this.loadDiffHtmlResults_(targetVersion);
			}
		}, {
			key: 'loadDiffHtmlResults_',
			value: function loadDiffHtmlResults_(targetVersion) {
				var _this2 = this;

				var portletNamespace = this.portletNamespace;


				var params = new _structs.MultiMap();

				params.add(portletNamespace + 'filterSourceVersion', this.sourceVersion);
				params.add(portletNamespace + 'filterTargetVersion', targetVersion);

				_Ajax2.default.request(this.resourceURL, 'get', null, null, params).then(function (xhrResponse) {
					_this2.diffHtmlResults = xhrResponse.response;
				}).catch(function () {
					_this2.diffHtmlResults = Liferay.Language.get('an-error-occurred-while-processing-the-requested-resource');
				});
			}
		}, {
			key: 'setterDiffHtmlResults_',
			value: function setterDiffHtmlResults_(value) {
				if ((0, _metal.isObject)(value)) {
					value = value.value.content;
				}

				return value;
			}
		}]);

		return DiffVersionComparator;
	}(_component2.default);

	DiffVersionComparator.STATE = {
		/**
   * List of locales that are available for the current asset. Used to render
   * locale selector.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {Array.<Object>}
   */
		availableLocales: _state.Config.array(),

		/**
   * HTML diff results that have been calculated by the server.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {String|Object}
   */
		diffHtmlResults: _state.Config.setter('setterDiffHtmlResults_'),

		/**
   * Array of diffVersion objects used for rendering dropdown menus and target
   * list.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {Array.<Object>}
   */
		diffVersions: _state.Config.array(),

		/**
   * Currently selected language id.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {String}
   */
		languageId: _state.Config.string(),

		/**
   * Portlet namespace.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {String}
   */
		portletNamespace: _state.Config.string(),

		/**
   * Portlet resource URL.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {String}
   */
		resourceURL: _state.Config.string(),

		/**
   * Total length of results after search input is used.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {number}
   */
		resultsLength: _state.Config.number(),

		/**
   * Currently selected version. Used for version filter header.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {Object}
   */
		selectedVersion: _state.Config.object(),

		/**
   * Currently selected source version.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {String}
   */
		sourceVersion: _state.Config.string(),

		/**
   * Determines if version filter should display.
   * @default false
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {boolean}
   */
		showVersionFilter: _state.Config.bool().value(false),

		/**
   * Currently selected target version.
   * @instance
   * @memberof DiffVersionComparator
   * @review
   * @type {String}
   */
		targetVersion: _state.Config.string()
	};

	_Soy2.default.register(DiffVersionComparator, _DiffVersionComparator2.default);

	exports.default = DiffVersionComparator;
	exports.DiffVersionComparator = DiffVersionComparator;
});
//# sourceMappingURL=DiffVersionComparator.es.js.map
