Liferay.Loader.define("frontend-taglib@3.1.2/translation_manager/TranslationManager.es", ['exports', 'frontend-js-web/liferay/CompatibilityEventProxy.es', 'metal-component/src/all/component', 'metal-soy/src/Soy', 'metal/src/metal', './TranslationManager.soy', 'frontend-js-web/liferay/compat/dropdown/Dropdown.es'], function (exports, _CompatibilityEventProxy, _component, _Soy, _metal, _TranslationManager) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _CompatibilityEventProxy2 = _interopRequireDefault(_CompatibilityEventProxy);

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _TranslationManager2 = _interopRequireDefault(_TranslationManager);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var TranslationManager = function (_Component) {
		_inherits(TranslationManager, _Component);

		/**
   * @inheritDoc
   */
		function TranslationManager(opt_config, opt_element) {
			_classCallCheck(this, TranslationManager);

			var _this = _possibleConstructorReturn(this, (TranslationManager.__proto__ || Object.getPrototypeOf(TranslationManager)).call(this, opt_config, opt_element));

			_this.resetEditingLocale_();

			_this.startCompatibility_();
			return _this;
		}

		/**
   * Add a language to the available locales list and set it as the
   * current editing language.
   * @param  {MouseEvent} event
   * @review
   */


		_createClass(TranslationManager, [{
			key: 'addLocale',
			value: function addLocale(event) {
				var localeId = event.delegateTarget.getAttribute('data-locale-id');

				if (this.availableLocales.indexOf(localeId) === -1) {
					this.availableLocales.push(localeId);
				}

				this.availableLocales = this.availableLocales;

				this.editingLocale = localeId;
			}
		}, {
			key: 'addTarget',
			value: function addTarget(target) {
				this.compatibilityEventProxy_.addTarget(target);
			}
		}, {
			key: 'changeDefaultLocale',
			value: function changeDefaultLocale(event) {
				var localeId = event.delegateTarget.getAttribute('data-locale-id');

				this.defaultLocale = localeId;

				this.editingLocale = localeId;
			}
		}, {
			key: 'changeLocale',
			value: function changeLocale(event) {
				var localeId = event.delegateTarget.getAttribute('data-locale-id');

				this.editingLocale = localeId;
			}
		}, {
			key: 'get',
			value: function get(attr) {
				return this[attr];
			}
		}, {
			key: 'removeAvailableLocale',
			value: function removeAvailableLocale(event) {
				var localeId = event.delegateTarget.getAttribute('data-locale-id');

				var localePosition = this.availableLocales.indexOf(localeId);

				this.availableLocales.splice(localePosition, 1);

				this.availableLocales = this.availableLocales;

				if (localeId === this.editingLocale) {
					this.resetEditingLocale_();
				}

				this.emit('deleteAvailableLocale', {
					locale: localeId
				});
			}
		}, {
			key: 'resetEditingLocale_',
			value: function resetEditingLocale_() {
				this.editingLocale = this.defaultLocale;
			}
		}, {
			key: 'startCompatibility_',
			value: function startCompatibility_() {
				this.destroy = this.dispose;

				this.compatibilityEventProxy_ = new _CompatibilityEventProxy2.default({
					host: this,
					namespace: 'translationmanager'
				});
			}
		}]);

		return TranslationManager;
	}(_component2.default);

	/**
  * State definition.
  * @ignore
  * @review
  * @static
  * @type {!Object}
  */
	TranslationManager.STATE = {
		/**
   * Current editing language key.
   * @review
   * @type {String}
   */
		editingLocale: {
			validator: _metal.core.isString
		},

		/**
   * List of available languages keys.
   * @review
   * @type {Array.<String>}
   */
		availableLocales: {
			validator: _metal.core.isArray
		},

		/**
   * Indicates if the default language is editable or not.
   * @review
   * @type {Boolean}
   */
		changeableDefaultLanguage: {
			validator: _metal.core.isBoolean
		},

		/**
   * Default language key.
   * @review
   * @type {String}
   */
		defaultLocale: {
			validator: _metal.core.isString
		},

		/**
   * Map of all languages
   * @review
   * @type {Object}
   */
		locales: {
			validator: _metal.core.isObject
		}
	};

	_Soy2.default.register(TranslationManager, _TranslationManager2.default);

	exports.default = TranslationManager;
});
//# sourceMappingURL=TranslationManager.es.js.map
