/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.servlet.taglib;

import com.liferay.frontend.taglib.internal.servlet.ServletContextUtil;
import com.liferay.frontend.taglib.servlet.taglib.AddMenuItem;
import com.liferay.frontend.taglib.servlet.taglib.MenuItem;
import com.liferay.frontend.taglib.servlet.taglib.MenuItemGroup;
import com.liferay.frontend.taglib.servlet.taglib.util.AddMenuKeys;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.taglib.util.IncludeTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class AddMenuTag
extends IncludeTag {
    private List<AddMenuItem> _addMenuItems = new ArrayList<AddMenuItem>();
    private boolean _inline;
    private int _maxItems = Integer.MAX_VALUE;
    private List<MenuItemGroup> _menuItemGroups = new ArrayList<MenuItemGroup>();
    private int _menuItemsCount;
    private int _numMenuItems;
    private int _total;
    private String _viewMoreURL;

    public int doEndTag() throws JspException {
        List addMenuItems = (List)this.request.getAttribute("liferay-frontend:add-menu:addMenuItems");
        if (ListUtil.isEmpty((List)addMenuItems)) {
            return 0;
        }
        this._menuItemsCount = addMenuItems.size();
        ArrayList<MenuItemGroup> menuItemGroups = new ArrayList<MenuItemGroup>();
        if (this._menuItemsCount == 1) {
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
            menuItems.addAll(this.getAddMenuItems());
            MenuItemGroup menuItem = new MenuItemGroup(AddMenuKeys.getAddMenuTypeLabel(AddMenuKeys.AddMenuType.DEFAULT), menuItems);
            menuItemGroups.add(menuItem);
            this._menuItemGroups = menuItemGroups;
        } else {
            ArrayList<MenuItem> primaryMenuItems = new ArrayList<MenuItem>();
            ArrayList<MenuItem> favoriteMenuItems = new ArrayList<MenuItem>();
            ArrayList<MenuItem> recentMenuItems = new ArrayList<MenuItem>();
            ArrayList<MenuItem> defaultMenuItems = new ArrayList<MenuItem>();
            for (AddMenuItem addMenuItem : this.getAddMenuItems()) {
                if (Objects.equals((Object)AddMenuKeys.AddMenuType.DEFAULT, (Object)addMenuItem.getType())) {
                    defaultMenuItems.add(addMenuItem);
                    continue;
                }
                if (Objects.equals((Object)AddMenuKeys.AddMenuType.FAVORITE, (Object)addMenuItem.getType())) {
                    favoriteMenuItems.add(addMenuItem);
                    continue;
                }
                if (Objects.equals((Object)AddMenuKeys.AddMenuType.PRIMARY, (Object)addMenuItem.getType())) {
                    primaryMenuItems.add(addMenuItem);
                    continue;
                }
                if (!Objects.equals((Object)AddMenuKeys.AddMenuType.RECENT, (Object)addMenuItem.getType())) continue;
                recentMenuItems.add(addMenuItem);
            }
            boolean showDivider = false;
            if (!(primaryMenuItems.isEmpty() || defaultMenuItems.isEmpty() && favoriteMenuItems.isEmpty() && recentMenuItems.isEmpty())) {
                showDivider = true;
            }
            menuItemGroups.add(new MenuItemGroup(primaryMenuItems, showDivider));
            showDivider = false;
            if (!(primaryMenuItems.isEmpty() || favoriteMenuItems.isEmpty() || recentMenuItems.isEmpty() && defaultMenuItems.isEmpty())) {
                showDivider = true;
            }
            MenuItemGroup favoriteMenuItem = new MenuItemGroup(AddMenuKeys.getAddMenuTypeLabel(AddMenuKeys.AddMenuType.FAVORITE), favoriteMenuItems, showDivider);
            menuItemGroups.add(favoriteMenuItem);
            menuItemGroups.add(new MenuItemGroup(recentMenuItems));
            menuItemGroups.add(new MenuItemGroup(defaultMenuItems));
            this._menuItemGroups = menuItemGroups;
            this._numMenuItems = this._maxItems;
            if (!primaryMenuItems.isEmpty()) {
                this._numMenuItems += primaryMenuItems.size();
                this._menuItemsCount -= primaryMenuItems.size();
            }
        }
        return super.doEndTag();
    }

    public int doStartTag() {
        this.request.setAttribute("liferay-frontend:add-menu:addMenuItems", this._addMenuItems);
        return 1;
    }

    public int getMaxItems() {
        return this._maxItems;
    }

    public String getViewMoreURL() {
        return this._viewMoreURL;
    }

    public boolean isInline() {
        return this._inline;
    }

    public void setAddMenuItems(List<AddMenuItem> addMenuItems) {
        this._addMenuItems = addMenuItems;
    }

    public void setInline(boolean inline) {
        this._inline = inline;
    }

    public void setMaxItems(int maxItems) {
        this._maxItems = maxItems;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    public void setViewMoreURL(String viewMoreURL) {
        this._viewMoreURL = viewMoreURL;
    }

    protected void cleanUp() {
        super.cleanUp();
        this._addMenuItems = new ArrayList<AddMenuItem>();
        this._inline = false;
        this._maxItems = Integer.MAX_VALUE;
        this._menuItemGroups = new ArrayList<MenuItemGroup>();
        this._menuItemsCount = 0;
        this._numMenuItems = 0;
        this._total = 0;
        this._viewMoreURL = null;
    }

    protected List<AddMenuItem> getAddMenuItems() {
        return (List)this.request.getAttribute("liferay-frontend:add-menu:addMenuItems");
    }

    protected String getPage() {
        return "/add_menu/page.jsp";
    }

    protected int getTotal() {
        List<AddMenuItem> addMenuItems = this.getAddMenuItems();
        return addMenuItems.size();
    }

    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("liferay-frontend:add-menu:inline", (Object)this._inline);
        httpServletRequest.setAttribute("liferay-frontend:add-menu:maxItems", (Object)this._maxItems);
        httpServletRequest.setAttribute("liferay-frontend:add-menu:menuItemGroups", this._menuItemGroups);
        httpServletRequest.setAttribute("liferay-frontend:add-menu:menuItemsCount", (Object)this._menuItemsCount);
        httpServletRequest.setAttribute("liferay-frontend:add-menu:numMenuItems", (Object)this._numMenuItems);
        httpServletRequest.setAttribute("liferay-frontend:add-menu:total", (Object)this.getTotal());
        httpServletRequest.setAttribute("liferay-frontend:add-menu:viewMoreURL", (Object)this._viewMoreURL);
    }
}

