/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.servlet.taglib.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JSPRenderer.class})
public class JSPRenderer {
    private static final Log _log = LogFactoryUtil.getLog(JSPRenderer.class);
    @Reference
    private Portal _portal;

    public void renderJSP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path) throws IOException {
        this.renderJSP(this.getServletContext(httpServletRequest), httpServletRequest, httpServletResponse, path);
    }

    public void renderJSP(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path) throws IOException {
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (ServletException se) {
            _log.error((Object)("Unable to render JSP " + path), (Throwable)se);
            throw new IOException("Unable to render " + path, se);
        }
    }

    @Deprecated
    public void setServletContext(ServletContext servletContext) {
    }

    protected ServletContext getServletContext(HttpServletRequest httpServletRequest) {
        String portletId = this._portal.getPortletId(httpServletRequest);
        if (Validator.isNotNull((String)portletId)) {
            String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
            PortletBag portletBag = PortletBagPool.get((String)rootPortletId);
            return portletBag.getServletContext();
        }
        return (ServletContext)httpServletRequest.getAttribute("CTX");
    }
}

