/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.servlet.taglib;

import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationCategory;
import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationEntry;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={ScreenNavigationRegistry.class})
public class ScreenNavigationRegistry {
    private BundleContext _bundleContext;
    private ServiceTrackerMap<String, List<ScreenNavigationCategory>> _screenNavigationCategoriesMap;
    private ServiceTrackerMap<String, List<ScreenNavigationEntry>> _screenNavigationEntriesMap;

    public <T> List<ScreenNavigationCategory> getScreenNavigationCategories(String screenNavigationId, User user, T context) {
        return ListUtil.filter((List)((List)this._screenNavigationCategoriesMap.getService((Object)screenNavigationId)), screenNavigationCategory -> {
            List<ScreenNavigationEntry> screenNavigationEntries = this.getScreenNavigationEntries((ScreenNavigationCategory)screenNavigationCategory, user, context);
            return ListUtil.isNotEmpty(screenNavigationEntries);
        });
    }

    public <T> List<ScreenNavigationEntry> getScreenNavigationEntries(ScreenNavigationCategory screenNavigationCategory, User user, T context) {
        String key = this._getKey(screenNavigationCategory.getScreenNavigationKey(), screenNavigationCategory.getCategoryKey());
        return ListUtil.filter((List)((List)this._screenNavigationEntriesMap.getService((Object)key)), screenNavigationEntry -> screenNavigationEntry.isVisible(user, context));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._screenNavigationCategoriesMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ScreenNavigationCategory.class, null, (ServiceReferenceMapper)new ScreenNavigationCategoriesServiceReferenceMapper(), Collections.reverseOrder(new PropertyServiceReferenceComparator("screen.navigation.category.order")));
        this._screenNavigationEntriesMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ScreenNavigationEntry.class, null, (ServiceReferenceMapper)new ScreenNavigationEntriesServiceReferenceMapper(), Collections.reverseOrder(new PropertyServiceReferenceComparator("screen.navigation.entry.order")));
    }

    @Deactivate
    protected void deactivate() {
        this._screenNavigationCategoriesMap.close();
        this._screenNavigationEntriesMap.close();
    }

    private String _getKey(String screenNavigationId, String screenCategoryKey) {
        return screenNavigationId + "." + screenCategoryKey;
    }

    private class ScreenNavigationEntriesServiceReferenceMapper
    implements ServiceReferenceMapper<String, ScreenNavigationEntry> {
        private ScreenNavigationEntriesServiceReferenceMapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(ServiceReference<ScreenNavigationEntry> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            ScreenNavigationEntry screenNavigationEntry = (ScreenNavigationEntry)ScreenNavigationRegistry.this._bundleContext.getService(serviceReference);
            try {
                String key = ScreenNavigationRegistry.this._getKey(screenNavigationEntry.getScreenNavigationKey(), screenNavigationEntry.getCategoryKey());
                emitter.emit((Object)key);
            }
            finally {
                ScreenNavigationRegistry.this._bundleContext.ungetService(serviceReference);
            }
        }
    }

    private class ScreenNavigationCategoriesServiceReferenceMapper
    implements ServiceReferenceMapper<String, ScreenNavigationCategory> {
        private ScreenNavigationCategoriesServiceReferenceMapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(ServiceReference<ScreenNavigationCategory> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            ScreenNavigationCategory screenNavigationCategory = (ScreenNavigationCategory)ScreenNavigationRegistry.this._bundleContext.getService(serviceReference);
            try {
                emitter.emit((Object)screenNavigationCategory.getScreenNavigationKey());
            }
            finally {
                ScreenNavigationRegistry.this._bundleContext.ungetService(serviceReference);
            }
        }
    }
}

