/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.servlet.taglib.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JSPRenderer.class})
public class JSPRenderer {
    private static final Log _log = LogFactoryUtil.getLog(JSPRenderer.class);
    @Reference
    private Portal _portal;
    private ServletContext _servletContext;

    public void renderJSP(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        this.renderJSP(this.getServletContext(request), request, response, path);
    }

    public void renderJSP(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        try {
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException se) {
            _log.error((Object)("Unable to render JSP " + path), (Throwable)se);
            throw new IOException("Unable to render " + path, se);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected ServletContext getServletContext(HttpServletRequest request) {
        if (this._servletContext != null) {
            return this._servletContext;
        }
        String portletId = this._portal.getPortletId(request);
        if (Validator.isNotNull((String)portletId)) {
            String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
            PortletBag portletBag = PortletBagPool.get((String)rootPortletId);
            return portletBag.getServletContext();
        }
        return (ServletContext)request.getAttribute("CTX");
    }
}

