Liferay.Loader.define('frontend-taglib$lodash-es@4.17.11/difference', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseDifference from './_baseDifference.js';
  import baseFlatten from './_baseFlatten.js';
  import baseRest from './_baseRest.js';
  import isArrayLikeObject from './isArrayLikeObject.js';

  /**
   * Creates an array of `array` values not included in the other given arrays
   * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
   * for equality comparisons. The order and references of result values are
   * determined by the first array.
   *
   * **Note:** Unlike `_.pullAll`, this method returns a new array.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Array
   * @param {Array} array The array to inspect.
   * @param {...Array} [values] The values to exclude.
   * @returns {Array} Returns the new array of filtered values.
   * @see _.without, _.xor
   * @example
   *
   * _.difference([2, 1], [2, 3]);
   * // => [1]
   */
  var difference = baseRest(function (array, values) {
    return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true)) : [];
  });

  export default difference;
});
//# sourceMappingURL=difference.js.map