Liferay.Loader.define('frontend-taglib$lodash-es@4.17.11/flatMapDeep', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseFlatten from './_baseFlatten.js';
  import map from './map.js';

  /** Used as references for various `Number` constants. */
  var INFINITY = 1 / 0;

  /**
   * This method is like `_.flatMap` except that it recursively flattens the
   * mapped results.
   *
   * @static
   * @memberOf _
   * @since 4.7.0
   * @category Collection
   * @param {Array|Object} collection The collection to iterate over.
   * @param {Function} [iteratee=_.identity] The function invoked per iteration.
   * @returns {Array} Returns the new flattened array.
   * @example
   *
   * function duplicate(n) {
   *   return [[[n, n]]];
   * }
   *
   * _.flatMapDeep([1, 2], duplicate);
   * // => [1, 1, 2, 2]
   */
  function flatMapDeep(collection, iteratee) {
    return baseFlatten(map(collection, iteratee), INFINITY);
  }

  export default flatMapDeep;
});
//# sourceMappingURL=flatMapDeep.js.map