Liferay.Loader.define('frontend-taglib$lodash-es@4.17.11/keysIn', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import arrayLikeKeys from './_arrayLikeKeys.js';
  import baseKeysIn from './_baseKeysIn.js';
  import isArrayLike from './isArrayLike.js';

  /**
   * Creates an array of the own and inherited enumerable property names of `object`.
   *
   * **Note:** Non-object values are coerced to objects.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category Object
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names.
   * @example
   *
   * function Foo() {
   *   this.a = 1;
   *   this.b = 2;
   * }
   *
   * Foo.prototype.c = 3;
   *
   * _.keysIn(new Foo);
   * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
   */
  function keysIn(object) {
    return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
  }

  export default keysIn;
});
//# sourceMappingURL=keysIn.js.map