Liferay.Loader.define('frontend-taglib$lodash-es@4.17.11/lowerCase', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import createCompounder from './_createCompounder.js';

  /**
   * Converts `string`, as space separated words, to lower case.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category String
   * @param {string} [string=''] The string to convert.
   * @returns {string} Returns the lower cased string.
   * @example
   *
   * _.lowerCase('--Foo-Bar--');
   * // => 'foo bar'
   *
   * _.lowerCase('fooBar');
   * // => 'foo bar'
   *
   * _.lowerCase('__FOO_BAR__');
   * // => 'foo bar'
   */
  var lowerCase = createCompounder(function (result, word, index) {
    return result + (index ? ' ' : '') + word.toLowerCase();
  });

  export default lowerCase;
});
//# sourceMappingURL=lowerCase.js.map