Liferay.Loader.define('frontend-taglib$lodash-es@4.17.11/property', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseProperty from './_baseProperty.js';
  import basePropertyDeep from './_basePropertyDeep.js';
  import isKey from './_isKey.js';
  import toKey from './_toKey.js';

  /**
   * Creates a function that returns the value at `path` of a given object.
   *
   * @static
   * @memberOf _
   * @since 2.4.0
   * @category Util
   * @param {Array|string} path The path of the property to get.
   * @returns {Function} Returns the new accessor function.
   * @example
   *
   * var objects = [
   *   { 'a': { 'b': 2 } },
   *   { 'a': { 'b': 1 } }
   * ];
   *
   * _.map(objects, _.property('a.b'));
   * // => [2, 1]
   *
   * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
   * // => [1, 2]
   */
  function property(path) {
    return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
  }

  export default property;
});
//# sourceMappingURL=property.js.map