Liferay.Loader.define('frontend-taglib$lodash-es@4.17.11/unionBy', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseFlatten from './_baseFlatten.js';
  import baseIteratee from './_baseIteratee.js';
  import baseRest from './_baseRest.js';
  import baseUniq from './_baseUniq.js';
  import isArrayLikeObject from './isArrayLikeObject.js';
  import last from './last.js';

  /**
   * This method is like `_.union` except that it accepts `iteratee` which is
   * invoked for each element of each `arrays` to generate the criterion by
   * which uniqueness is computed. Result values are chosen from the first
   * array in which the value occurs. The iteratee is invoked with one argument:
   * (value).
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Array
   * @param {...Array} [arrays] The arrays to inspect.
   * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
   * @returns {Array} Returns the new array of combined values.
   * @example
   *
   * _.unionBy([2.1], [1.2, 2.3], Math.floor);
   * // => [2.1, 1.2]
   *
   * // The `_.property` iteratee shorthand.
   * _.unionBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
   * // => [{ 'x': 1 }, { 'x': 2 }]
   */
  var unionBy = baseRest(function (arrays) {
    var iteratee = last(arrays);
    if (isArrayLikeObject(iteratee)) {
      iteratee = undefined;
    }
    return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), baseIteratee(iteratee, 2));
  });

  export default unionBy;
});
//# sourceMappingURL=unionBy.js.map