Liferay.Loader.define("frontend-taglib@5.4.3/diff_version_comparator/index", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/card', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$react', './components/Diff', './components/Filter', './components/List', './components/LocaleSelector', './components/Selector', './utils/sub'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _card = _interopRequireDefault(require("@frontend-taglib-clay$clayui/card"));

  var _form = require("@frontend-taglib-clay$clayui/form");

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _frontendJsWeb = require("frontend-js-web");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _Diff = _interopRequireDefault(require("./components/Diff"));

  var _Filter = _interopRequireDefault(require("./components/Filter"));

  var _List = _interopRequireDefault(require("./components/List"));

  var _LocaleSelector = _interopRequireDefault(require("./components/LocaleSelector"));

  var _Selector = _interopRequireDefault(require("./components/Selector"));

  var _sub = _interopRequireDefault(require("./utils/sub"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function Comparator(_ref) {
    var availableLocales = _ref.availableLocales,
        diffHtmlResults = _ref.diffHtmlResults,
        diffVersions = _ref.diffVersions,
        languageId = _ref.languageId,
        nextVersion = _ref.nextVersion,
        portletNamespace = _ref.portletNamespace,
        portletURL = _ref.portletURL,
        previousVersion = _ref.previousVersion,
        resourceURL = _ref.resourceURL,
        sourceVersion = _ref.sourceVersion,
        targetVersion = _ref.targetVersion;
    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
    var availableVersions = (0, _react.useMemo)(function () {
      return diffVersions.filter(function (diffVersion) {
        return sourceVersion !== diffVersion.version && targetVersion !== diffVersion.version;
      });
    }, [diffVersions, sourceVersion, targetVersion]);
    var selectableVersions = (0, _react.useMemo)(function () {
      return availableVersions.filter(function (version) {
        return version.inRange;
      });
    }, [availableVersions]);
    var getDiffURL = (0, _react.useCallback)(function (filterTargetVersion) {
      var diffURL = new URL(resourceURL);
      diffURL.searchParams.append("".concat(portletNamespace, "filterSourceVersion"), sourceVersion);
      diffURL.searchParams.append("".concat(portletNamespace, "filterTargetVersion"), filterTargetVersion);
      return diffURL.toString();
    }, [portletNamespace, resourceURL, sourceVersion]);
    var handleFilterChange = (0, _react.useCallback)(function (event) {
      var query = event.target.value.toLowerCase();
      var visibleVersions = selectableVersions.filter(function (_ref2) {
        var label = _ref2.label,
            userName = _ref2.userName;
        return label.toLowerCase().includes(query) || userName.toLowerCase().includes(query);
      });
      setFilterQuery(query);
      setVisibleVersions(visibleVersions);
    }, [selectableVersions]);

    var _useState = (0, _react.useState)(diffHtmlResults),
        _useState2 = _slicedToArray(_useState, 2),
        diff = _useState2[0],
        setDiff = _useState2[1];

    var _useState3 = (0, _react.useState)(getDiffURL(targetVersion)),
        _useState4 = _slicedToArray(_useState3, 2),
        diffURL = _useState4[0],
        setDiffURL = _useState4[1];

    var _useState5 = (0, _react.useState)(''),
        _useState6 = _slicedToArray(_useState5, 2),
        filterQuery = _useState6[0],
        setFilterQuery = _useState6[1];

    var _useState7 = (0, _react.useState)(languageId),
        _useState8 = _slicedToArray(_useState7, 2),
        selectedLanguageId = _useState8[0],
        setSelectedLanguageId = _useState8[1];

    var _useState9 = (0, _react.useState)(null),
        _useState10 = _slicedToArray(_useState9, 2),
        selectedVersion = _useState10[0],
        setSelectedVersion = _useState10[1];

    var _useState11 = (0, _react.useState)(selectableVersions),
        _useState12 = _slicedToArray(_useState11, 2),
        visibleVersions = _useState12[0],
        setVisibleVersions = _useState12[1];

    var diffCache = (0, _react.useRef)(_defineProperty({}, diffURL, diff));
    var formRef = (0, _react.useRef)();
    var handleTargetChange = (0, _react.useCallback)(function (event) {
      var target = event.target.closest('[data-version]');
      var currentTargetVersion = target ? target.getAttribute('data-version') : null;
      var selectedVersion = selectableVersions.find(function (version) {
        return version.version === currentTargetVersion;
      });
      setDiffURL(getDiffURL(currentTargetVersion || targetVersion));
      setSelectedVersion(selectedVersion);
    }, [getDiffURL, selectableVersions, targetVersion]);
    (0, _react.useEffect)(function () {
      var cached = diffCache.current[diffURL];

      if (cached) {
        setDiff(cached);
      } else {
        (0, _frontendJsWeb.fetch)(diffURL).then(function (res) {
          return res.text();
        }).then(function (text) {
          diffCache.current[diffURL] = text;
        })["catch"](function () {
          diffCache.current[diffURL] = Liferay.Language.get('an-error-occurred-while-processing-the-requested-resource');
        })["finally"](function () {
          if (isMounted()) {
            setDiff(diffCache.current[diffURL]);
          }
        });
      }
    }, [diffURL, isMounted]);
    return _react["default"].createElement("form", {
      action: portletURL,
      className: "container-fluid-1280 diff-version-comparator",
      method: "post",
      name: "".concat(portletNamespace, "diffVersionFm"),
      ref: formRef
    }, _react["default"].createElement(_form.ClayInput, {
      name: "".concat(portletNamespace, "sourceVersion"),
      type: "hidden",
      value: sourceVersion
    }), _react["default"].createElement(_form.ClayInput, {
      name: "".concat(portletNamespace, "targetVersion"),
      type: "hidden",
      value: targetVersion
    }), _react["default"].createElement(_card["default"], {
      className: "main-content-card",
      horizontal: true
    }, _react["default"].createElement(_card["default"].Body, null, _react["default"].createElement(_card["default"].Description, {
      displayType: "title"
    }, Liferay.Language.get('you-are-comparing-these-versions')), _react["default"].createElement(_card["default"].Row, null, _react["default"].createElement("div", {
      className: "col-md-4"
    }, _react["default"].createElement("div", {
      className: "float-right"
    }, _react["default"].createElement(_Selector["default"], {
      label: (0, _sub["default"])(Liferay.Language.get('version-x'), [sourceVersion]),
      selectedVersion: previousVersion,
      uniqueVersionLabel: Liferay.Language.get('first-version'),
      urlSelector: "sourceURL",
      versions: availableVersions
    }))), _react["default"].createElement("div", {
      className: "col-md-8 diff-target-selector"
    }, _react["default"].createElement(_Selector["default"], {
      label: (0, _sub["default"])(Liferay.Language.get('version-x'), [targetVersion]),
      selectedVersion: nextVersion,
      uniqueVersionLabel: Liferay.Language.get('last-version'),
      urlSelector: "targetURL",
      versions: availableVersions
    }))), _react["default"].createElement("div", {
      className: "divider row"
    }), _react["default"].createElement(_card["default"].Row, null, _react["default"].createElement("div", {
      className: "col-md-4"
    }, selectableVersions.length >= 5 && _react["default"].createElement(_Filter["default"], {
      onChange: handleFilterChange,
      query: filterQuery
    }), availableLocales && availableLocales.length > 1 && _react["default"].createElement(_LocaleSelector["default"], {
      locales: availableLocales,
      onChange: function onChange(event) {
        setSelectedLanguageId(event.target.value);
        submitForm(formRef.current);
      },
      portletNamespace: portletNamespace,
      selectedLanguageId: selectedLanguageId
    }), _react["default"].createElement(_List["default"], {
      onChange: handleTargetChange,
      selected: selectedVersion,
      versions: visibleVersions
    })), _react["default"].createElement("div", {
      className: "col-md-8"
    }, _react["default"].createElement(_Diff["default"], {
      diff: diff,
      onClose: handleTargetChange,
      version: selectedVersion
    }))))));
  }

  var _default = Comparator;
  exports["default"] = _default;
  //# sourceMappingURL=index.js.map
});
//# sourceMappingURL=index.js.map