"use strict";

Liferay.Loader.define("frontend-taglib$dnd-core@11.1.3/dist/cjs/utils/equality", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.areCoordsEqual = areCoordsEqual;
  exports.areArraysEqual = areArraysEqual;
  exports.strictEquality = void 0;

  var strictEquality = function strictEquality(a, b) {
    return a === b;
  };
  /**
   * Determine if two cartesian coordinate offsets are equal
   * @param offsetA
   * @param offsetB
   */

  exports.strictEquality = strictEquality;

  function areCoordsEqual(offsetA, offsetB) {
    if (!offsetA && !offsetB) {
      return true;
    } else if (!offsetA || !offsetB) {
      return false;
    } else {
      return offsetA.x === offsetB.x && offsetA.y === offsetB.y;
    }
  }
  /**
   * Determines if two arrays of items are equal
   * @param a The first array of items
   * @param b The second array of items
   */

  function areArraysEqual(a, b) {
    var isEqual = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : strictEquality;

    if (a.length !== b.length) {
      return false;
    }

    for (var i = 0; i < a.length; ++i) {
      if (!isEqual(a[i], b[i])) {
        return false;
      }
    }

    return true;
  }
});
//# sourceMappingURL=equality.js.map