Liferay.Loader.define('frontend-taglib$lodash-es@4.17.15/_arrayIncludes', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseIndexOf from './_baseIndexOf.js';

  /**
   * A specialized version of `_.includes` for arrays without support for
   * specifying an index to search from.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */
  function arrayIncludes(array, value) {
    var length = array == null ? 0 : array.length;
    return !!length && baseIndexOf(array, value, 0) > -1;
  }

  export default arrayIncludes;
});
//# sourceMappingURL=_arrayIncludes.js.map