Liferay.Loader.define('frontend-taglib$lodash-es@4.17.15/_baseEvery', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseEach from './_baseEach.js';

  /**
   * The base implementation of `_.every` without support for iteratee shorthands.
   *
   * @private
   * @param {Array|Object} collection The collection to iterate over.
   * @param {Function} predicate The function invoked per iteration.
   * @returns {boolean} Returns `true` if all elements pass the predicate check,
   *  else `false`
   */
  function baseEvery(collection, predicate) {
    var result = true;
    baseEach(collection, function (value, index, collection) {
      result = !!predicate(value, index, collection);
      return result;
    });
    return result;
  }

  export default baseEvery;
});
//# sourceMappingURL=_baseEvery.js.map