Liferay.Loader.define('frontend-taglib$lodash-es@4.17.15/_cloneArrayBuffer', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import Uint8Array from './_Uint8Array.js';

  /**
   * Creates a clone of `arrayBuffer`.
   *
   * @private
   * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
   * @returns {ArrayBuffer} Returns the cloned array buffer.
   */
  function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array(result).set(new Uint8Array(arrayBuffer));
    return result;
  }

  export default cloneArrayBuffer;
});
//# sourceMappingURL=_cloneArrayBuffer.js.map