Liferay.Loader.define('frontend-taglib$lodash-es@4.17.15/_hasPath', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import castPath from './_castPath.js';
  import isArguments from './isArguments.js';
  import isArray from './isArray.js';
  import isIndex from './_isIndex.js';
  import isLength from './isLength.js';
  import toKey from './_toKey.js';

  /**
   * Checks if `path` exists on `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {Array|string} path The path to check.
   * @param {Function} hasFunc The function to check properties.
   * @returns {boolean} Returns `true` if `path` exists, else `false`.
   */
  function hasPath(object, path, hasFunc) {
    path = castPath(path, object);

    var index = -1,
        length = path.length,
        result = false;

    while (++index < length) {
      var key = toKey(path[index]);
      if (!(result = object != null && hasFunc(object, key))) {
        break;
      }
      object = object[key];
    }
    if (result || ++index != length) {
      return result;
    }
    length = object == null ? 0 : object.length;
    return !!length && isLength(length) && isIndex(key, length) && (isArray(object) || isArguments(object));
  }

  export default hasPath;
});
//# sourceMappingURL=_hasPath.js.map