Liferay.Loader.define('frontend-taglib$lodash-es@4.17.15/min', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseExtremum from './_baseExtremum.js';
  import baseLt from './_baseLt.js';
  import identity from './identity.js';

  /**
   * Computes the minimum value of `array`. If `array` is empty or falsey,
   * `undefined` is returned.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Math
   * @param {Array} array The array to iterate over.
   * @returns {*} Returns the minimum value.
   * @example
   *
   * _.min([4, 2, 8, 6]);
   * // => 2
   *
   * _.min([]);
   * // => undefined
   */
  function min(array) {
    return array && array.length ? baseExtremum(array, identity, baseLt) : undefined;
  }

  export default min;
});
//# sourceMappingURL=min.js.map