Liferay.Loader.define('frontend-taglib$lodash-es@4.17.15/subtract', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import createMathOperation from './_createMathOperation.js';

  /**
   * Subtract two numbers.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Math
   * @param {number} minuend The first number in a subtraction.
   * @param {number} subtrahend The second number in a subtraction.
   * @returns {number} Returns the difference.
   * @example
   *
   * _.subtract(6, 4);
   * // => 2
   */
  var subtract = createMathOperation(function (minuend, subtrahend) {
    return minuend - subtrahend;
  }, 0);

  export default subtract;
});
//# sourceMappingURL=subtract.js.map