"use strict";

Liferay.Loader.define("frontend-taglib$dom-helpers@5.2.0/cjs/removeClass", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    exports.__esModule = true;
    exports.default = removeClass;

    function replaceClassName(origClass, classToRemove) {
      return origClass.replace(new RegExp("(^|\\s)" + classToRemove + "(?:\\s|$)", 'g'), '$1').replace(/\s+/g, ' ').replace(/^\s*|\s*$/g, '');
    }

    function removeClass(element, className) {
      if (element.classList) {
        element.classList.remove(className);
      } else if (typeof element.className === 'string') {
        element.className = replaceClassName(element.className, className);
      } else {
        element.setAttribute('class', replaceClassName(element.className && element.className.baseVal || '', className));
      }
    }

    module.exports = exports["default"];
  }
});
//# sourceMappingURL=removeClass.js.map