Liferay.Loader.define("frontend-taglib@5.6.4/translation_manager/components/LocalesList", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/tabs', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = LocalesList;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _tabs = _interopRequireDefault(require("@frontend-taglib-clay$clayui/tabs"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var Locale = function Locale(_ref) {
      var children = _ref.children,
          editingLocale = _ref.editingLocale,
          locale = _ref.locale,
          onLocaleClicked = _ref.onLocaleClicked;
      return (/*#__PURE__*/_react.default.createElement(_tabs.default.Item, {
          active: editingLocale === locale.id,
          onClick: function onClick() {
            return onLocaleClicked && onLocaleClicked(locale);
          }
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: "inline-item-before",
          symbol: locale.icon
        }), /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item-before"
        }, locale.label), children)
      );
    };

    function LocalesList(_ref2) {
      var availableLocales = _ref2.availableLocales,
          changeableDefaultLanguage = _ref2.changeableDefaultLanguage,
          defaultLocale = _ref2.defaultLocale,
          editingLocale = _ref2.editingLocale,
          _onLocaleClicked = _ref2.onLocaleClicked,
          onLocaleRemoved = _ref2.onLocaleRemoved;
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Array.from(availableLocales.values()).map(function (locale) {
          return (/*#__PURE__*/_react.default.createElement(Locale, {
              editingLocale: editingLocale,
              key: locale.id,
              locale: locale,
              onLocaleClicked: function onLocaleClicked() {
                return _onLocaleClicked && _onLocaleClicked(locale);
              }
            }, changeableDefaultLanguage && defaultLocale === locale.id || locale.id !== defaultLocale && /*#__PURE__*/_react.default.createElement(_button.default, {
              displayType: "unstyled",
              onClick: function onClick() {
                return onLocaleRemoved && onLocaleRemoved(locale);
              },
              small: true
            }, /*#__PURE__*/_react.default.createElement(_icon.default, {
              symbol: "times-small"
            })))
          );
        }))
      );
    }
    //# sourceMappingURL=LocalesList.js.map
  }
});
//# sourceMappingURL=LocalesList.js.map