Liferay.Loader.define("frontend-taglib@5.6.4/translation_manager/index", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './components/DeleteLocaleModal', './components/LocaleSelector', './components/LocalesContainer', './components/LocalesList', './hooks/useRegistry'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _modal = require("@frontend-taglib-clay$clayui/modal");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _DeleteLocaleModal = _interopRequireDefault(require("./components/DeleteLocaleModal"));

    var _LocaleSelector = _interopRequireDefault(require("./components/LocaleSelector"));

    var _LocalesContainer = _interopRequireDefault(require("./components/LocalesContainer"));

    var _LocalesList = _interopRequireDefault(require("./components/LocalesList"));

    var _useRegistry = _interopRequireDefault(require("./hooks/useRegistry"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var TranslationManager = function TranslationManager(_ref) {
      var initialAvailableLocales = _ref.availableLocales,
          changeableDefaultLanguage = _ref.changeableDefaultLanguage,
          componentId = _ref.componentId,
          cssClass = _ref.cssClass,
          initialDefaultLanguageId = _ref.defaultLanguageId,
          id = _ref.id,
          locales = _ref.locales,
          readOnly = _ref.readOnly;
      var compId = componentId ? componentId : id;

      var _useState = (0, _react.useState)(initialAvailableLocales),
          _useState2 = _slicedToArray(_useState, 2),
          availableLocales = _useState2[0],
          setAvailableLocales = _useState2[1];

      var _useState3 = (0, _react.useState)(initialDefaultLanguageId),
          _useState4 = _slicedToArray(_useState3, 2),
          defaultLocale = _useState4[0],
          setDefaultLocale = _useState4[1];

      var _useState5 = (0, _react.useState)(initialDefaultLanguageId),
          _useState6 = _slicedToArray(_useState5, 2),
          editingLocale = _useState6[0],
          setEditingLocale = _useState6[1];

      var _useState7 = (0, _react.useState)(false),
          _useState8 = _slicedToArray(_useState7, 2),
          visibleModal = _useState8[0],
          setVisibleModal = _useState8[1];

      (0, _useRegistry.default)({
        componentId: compId,
        states: {
          availableLocales: availableLocales,
          defaultLocale: defaultLocale,
          editingLocale: editingLocale
        }
      });

      var _useModal = (0, _modal.useModal)({
        onClose: function onClose() {
          return setVisibleModal(false);
        }
      }),
          observer = _useModal.observer,
          onClose = _useModal.onClose;

      var localeToBeRemoved = _react.default.useRef(null);

      var removeLocale = function removeLocale(locale) {
        if (defaultLocale === locale.id) {
          setDefaultLocale(editingLocale);
        }

        if (editingLocale === locale.id) {
          setEditingLocale(defaultLocale);
        }

        var newAvailableLocales = new Map(availableLocales);
        newAvailableLocales.delete(locale.id);
        setAvailableLocales(newAvailableLocales);
      };

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visibleModal && /*#__PURE__*/_react.default.createElement(_DeleteLocaleModal.default, {
          observer: observer,
          onCancel: function onCancel() {
            localeToBeRemoved.current = null;
            onClose();
          },
          onConfirm: function onConfirm() {
            removeLocale(localeToBeRemoved.current);
            onClose();
          }
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: "autofit-row"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "autofit-col"
        }, /*#__PURE__*/_react.default.createElement(_LocalesContainer.default, {
          className: cssClass,
          id: id,
          readOnly: readOnly
        }, /*#__PURE__*/_react.default.createElement(_LocalesList.default, {
          availableLocales: availableLocales,
          changeableDefaultLanguage: changeableDefaultLanguage,
          defaultLocale: defaultLocale,
          editingLocale: editingLocale,
          onLocaleClicked: function onLocaleClicked(locale) {
            if (changeableDefaultLanguage) {
              setDefaultLocale(locale.id);
            }

            setEditingLocale(locale.id);
          },
          onLocaleRemoved: function onLocaleRemoved(locale) {
            localeToBeRemoved.current = locale;
            setVisibleModal(true);
          }
        }))), /*#__PURE__*/_react.default.createElement("div", {
          className: "autofit-col"
        }, /*#__PURE__*/_react.default.createElement(_LocaleSelector.default, {
          locales: locales,
          onItemClick: function onItemClick(locale) {
            setAvailableLocales(new Map(availableLocales).set(locale.id, locale));
            setEditingLocale(locale.id);
          }
        }))))
      );
    };

    function _default(props) {
      var availableLocales = new Map(props.availableLocales.map(function (locale) {
        return [locale.id, locale];
      }));
      return (/*#__PURE__*/_react.default.createElement(TranslationManager, _extends({}, props, {
          availableLocales: availableLocales
        }))
      );
    }
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map