/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.patcher;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.copy.ReplaceLeadingPathAction;
import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.filters.FixCrLfFilter;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.gradle.util.GUtil;

public class PatchTask
extends DefaultTask {
    public static final String PATCHED_SRC_DIR_MAPPING_DEFAULT_EXTENSION = "*";
    private static final String _BASE_URL = "http://repo.maven.apache.org/maven2/";
    private boolean _copyOriginalLibClasses = true;
    private final List<Object> _fileNames = new ArrayList<Object>();
    private Object _originalLibConfigurationName = "compile";
    private Object _originalLibModuleName;
    private Object _originalLibSrcDirName = ".";
    private final Map<String, Object> _patchedSrcDirMappings = new HashMap<String, Object>();
    private Object _patchesDir = "patches";
    private final List<Object> _patchFiles = new ArrayList<Object>();
    private final Project _project = this.getProject();

    public PatchTask fileNames(Iterable<Object> fileNames) {
        GUtil.addToCollection(this._fileNames, (Iterable[])new Iterable[]{fileNames});
        return this;
    }

    public PatchTask fileNames(Object ... fileNames) {
        return this.fileNames(Arrays.asList(fileNames));
    }

    @Input
    public List<String> getFileNames() {
        return GradleUtil.toStringList(this._fileNames);
    }

    @Input
    public String getOriginalLibConfigurationName() {
        return GradleUtil.toString((Object)this._originalLibConfigurationName);
    }

    public File getOriginalLibFile() {
        Configuration configuration = GradleUtil.getConfiguration((Project)this._project, (String)this.getOriginalLibConfigurationName());
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        String moduleGroup = this.getOriginalLibModuleGroup();
        String moduleName = this.getOriginalLibModuleName();
        String moduleVersion = this.getOriginalLibModuleVersion();
        for (ResolvedArtifact resolvedArtifact : resolvedConfiguration.getResolvedArtifacts()) {
            ResolvedModuleVersion resolvedModuleVersion = resolvedArtifact.getModuleVersion();
            ModuleVersionIdentifier moduleVersionIdentifier = resolvedModuleVersion.getId();
            if (!moduleGroup.equals(moduleVersionIdentifier.getGroup()) || !moduleName.equals(moduleVersionIdentifier.getName()) || !moduleVersion.equals(moduleVersionIdentifier.getVersion())) continue;
            return resolvedArtifact.getFile();
        }
        throw new GradleException("Unable to find original lib " + moduleName);
    }

    @Input
    public String getOriginalLibModuleGroup() {
        Dependency dependency = this.getOriginalLibDependency();
        return dependency.getGroup();
    }

    @Input
    public String getOriginalLibModuleName() {
        return GradleUtil.toString((Object)this._originalLibModuleName);
    }

    @Input
    public String getOriginalLibModuleVersion() {
        Dependency dependency = this.getOriginalLibDependency();
        return dependency.getVersion();
    }

    @Input
    public String getOriginalLibSrcDirName() {
        return GradleUtil.toString((Object)this._originalLibSrcDirName);
    }

    public File getOriginalLibSrcFile() throws Exception {
        return FileUtil.get((Project)this._project, (String)this.getOriginalLibSrcUrl());
    }

    public Map<String, File> getPatchedSrcDirMappings() {
        HashMap<String, File> patchedSrcDirMappings = new HashMap<String, File>();
        for (Map.Entry<String, Object> entry : this._patchedSrcDirMappings.entrySet()) {
            String extension = entry.getKey();
            File dir = GradleUtil.toFile((Project)this._project, (Object)entry.getValue());
            patchedSrcDirMappings.put(extension, dir);
        }
        return patchedSrcDirMappings;
    }

    @OutputFiles
    public FileCollection getPatchedSrcFiles() {
        HashMap<File, ConfigurableFileTree> patchedSrcFileTreeMap = new HashMap<File, ConfigurableFileTree>();
        for (String fileName : this.getFileNames()) {
            File patchedDir = this.getPatchedSrcDir(fileName);
            ConfigurableFileTree configurableFileTree = (ConfigurableFileTree)patchedSrcFileTreeMap.get(patchedDir);
            if (configurableFileTree == null) {
                configurableFileTree = this._project.fileTree((Object)patchedDir);
                patchedSrcFileTreeMap.put(patchedDir, configurableFileTree);
            }
            configurableFileTree.include(new String[]{fileName});
        }
        Collection patchedSrcFileTrees = patchedSrcFileTreeMap.values();
        return this._project.files(patchedSrcFileTrees.toArray());
    }

    public File getPatchesDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._patchesDir);
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getPatchFiles() {
        if (!this._patchFiles.isEmpty()) {
            return this._project.files(new Object[]{this._patchFiles});
        }
        return this._project.fileTree(this._patchesDir);
    }

    public boolean isCopyOriginalLibClasses() {
        return this._copyOriginalLibClasses;
    }

    @TaskAction
    public void patch() throws Exception {
        final File temporaryDir = this.getTemporaryDir();
        this._project.delete(new Object[]{temporaryDir});
        temporaryDir.mkdir();
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(CopySpec copySpec) throws Exception {
                String originalLibSrcDirName = PatchTask.this.getOriginalLibSrcDirName();
                if (!originalLibSrcDirName.equals(".")) {
                    HashMap<String, String> leadingPathReplacementsMap = new HashMap<String, String>();
                    leadingPathReplacementsMap.put(originalLibSrcDirName, "");
                    copySpec.eachFile((Action)new ReplaceLeadingPathAction(leadingPathReplacementsMap));
                }
                copySpec.filter(FixCrLfFilter.class);
                copySpec.from(new Object[]{PatchTask.this._project.zipTree((Object)PatchTask.this.getOriginalLibSrcFile())});
                copySpec.include(PatchTask.this.getFileNames());
                copySpec.into((Object)temporaryDir);
                copySpec.setIncludeEmptyDirs(false);
            }
        };
        this._project.copy((Closure)closure);
        for (final File patchFile : this.getPatchFiles()) {
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this._project.exec((Action)new Action<ExecSpec>(){

                public void execute(ExecSpec execSpec) {
                    execSpec.setExecutable((Object)"patch");
                    execSpec.setWorkingDir((Object)temporaryDir);
                    execSpec.args(new Object[]{"--binary"});
                    execSpec.args(new Object[]{"--input=" + FileUtil.relativize((File)patchFile, (File)temporaryDir)});
                    execSpec.args(new Object[]{"--strip=1"});
                    execSpec.setStandardOutput((OutputStream)byteArrayOutputStream);
                }
            });
            System.out.println(byteArrayOutputStream.toString());
        }
        ConfigurableFileTree fileTree = this._project.fileTree((Object)temporaryDir);
        for (File file : fileTree) {
            File patchedSrcDir = this.getPatchedSrcDir(file.getName());
            if (patchedSrcDir == null) continue;
            Path patchedSrcDirPath = patchedSrcDir.toPath();
            String relativePath = FileUtil.relativize((File)file, (File)temporaryDir);
            patchedSrcDirPath = patchedSrcDirPath.resolve(relativePath);
            Files.createDirectories(patchedSrcDirPath.getParent(), new FileAttribute[0]);
            Files.move(file.toPath(), patchedSrcDirPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public PatchTask patchedSrcDirMapping(String extension, Object dir) {
        this._patchedSrcDirMappings.put(extension, dir);
        return this;
    }

    public PatchTask patchFiles(Iterable<Object> patchFiles) {
        GUtil.addToCollection(this._patchFiles, (Iterable[])new Iterable[]{patchFiles});
        return this;
    }

    public PatchTask patchFiles(Object ... patchFiles) {
        return this.patchFiles(Arrays.asList(patchFiles));
    }

    public void setCopyOriginalLibClasses(boolean copyOriginalLibClasses) {
        this._copyOriginalLibClasses = copyOriginalLibClasses;
    }

    public void setFileNames(Iterable<Object> fileNames) {
        this._fileNames.clear();
        this.fileNames(fileNames);
    }

    public void setOriginalLibConfigurationName(Object originalLibConfigurationName) {
        this._originalLibConfigurationName = originalLibConfigurationName;
    }

    public void setOriginalLibModuleName(Object originalLibModuleName) {
        this._originalLibModuleName = originalLibModuleName;
    }

    public void setOriginalLibSrcDirName(Object originalLibSrcDirName) {
        this._originalLibSrcDirName = originalLibSrcDirName;
    }

    public void setPatchedSrcDirMappings(Map<String, Object> patchedSrcDirMappings) {
        this._patchedSrcDirMappings.clear();
        this._patchedSrcDirMappings.putAll(patchedSrcDirMappings);
    }

    public void setPatchesDir(Object patchesDir) {
        this._patchesDir = patchesDir;
    }

    public void setPatchFiles(Iterable<Object> patchFiles) {
        this._patchFiles.clear();
        this.patchFiles(patchFiles);
    }

    protected Dependency getOriginalLibDependency() {
        Configuration configuration = GradleUtil.getConfiguration((Project)this._project, (String)this.getOriginalLibConfigurationName());
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        String moduleName = this.getOriginalLibModuleName();
        for (Dependency dependency : resolvableDependencies.getDependencies()) {
            if (!moduleName.equals(dependency.getName())) continue;
            return dependency;
        }
        throw new GradleException("Unable to find original lib " + moduleName);
    }

    protected String getOriginalLibSrcUrl() {
        StringBuilder sb = new StringBuilder(_BASE_URL);
        String moduleGroup = this.getOriginalLibModuleGroup();
        sb.append(moduleGroup.replace('.', '/'));
        sb.append('/');
        sb.append(this.getOriginalLibModuleName());
        sb.append('/');
        sb.append(this.getOriginalLibModuleVersion());
        sb.append('/');
        sb.append(this.getOriginalLibModuleName());
        sb.append('-');
        sb.append(this.getOriginalLibModuleVersion());
        sb.append("-sources.jar");
        return sb.toString();
    }

    protected File getPatchedSrcDir(String fileName) {
        Object patchedSrcDir;
        String extension = PATCHED_SRC_DIR_MAPPING_DEFAULT_EXTENSION;
        int pos = fileName.indexOf(46);
        if (pos != -1) {
            extension = fileName.substring(pos + 1);
        }
        if ((patchedSrcDir = this._patchedSrcDirMappings.get(extension)) == null) {
            patchedSrcDir = this._patchedSrcDirMappings.get(PATCHED_SRC_DIR_MAPPING_DEFAULT_EXTENSION);
        }
        return GradleUtil.toFile((Project)this._project, (Object)patchedSrcDir);
    }
}

