/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.patcher;

import com.liferay.gradle.plugins.patcher.PatchTask;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.copy.ExcludeExistingFileAction;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.compile.JavaCompile;

public class PatcherPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PatchTask.class, (Action)new Action<PatchTask>(){

            public void execute(PatchTask patchTask) {
                PatcherPlugin.this.configureTaskPatchPatchedSrcDirMappings(patchTask);
                Project project = patchTask.getProject();
                JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJava");
                javaCompile.dependsOn(new Object[]{patchTask});
                Copy copy = PatcherPlugin.this.addTaskCopyOriginalLibClasses(patchTask);
                Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
                classesTask.dependsOn(new Object[]{copy});
            }
        });
    }

    protected Copy addTaskCopyOriginalLibClasses(final PatchTask patchTask) {
        String taskName = "copy" + StringUtil.capitalize((String)patchTask.getName()) + "OriginalLibClasses";
        Copy copy = (Copy)GradleUtil.addTask((Project)patchTask.getProject(), (String)taskName, Copy.class);
        copy.eachFile((Action)new ExcludeExistingFileAction(copy.getDestinationDir()));
        copy.from(new Object[]{new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                Project project = patchTask.getProject();
                return project.zipTree((Object)patchTask.getOriginalLibFile());
            }
        }});
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)patchTask.getProject(), (String)"compileJava");
                return javaCompile.getDestinationDir();
            }
        });
        copy.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return patchTask.isCopyOriginalLibClasses();
            }
        });
        TaskOutputsInternal taskOutputs = copy.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
        return copy;
    }

    protected void configureTaskPatchPatchedSrcDirMappings(PatchTask patchTask) {
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)patchTask.getProject(), (String)"main");
        patchTask.patchedSrcDirMapping("java", new Callable<File>(){

            @Override
            public File call() throws Exception {
                return PatcherPlugin.this.getSrcDir(sourceSet.getJava());
            }
        });
        patchTask.patchedSrcDirMapping("*", new Callable<File>(){

            @Override
            public File call() throws Exception {
                return PatcherPlugin.this.getSrcDir(sourceSet.getResources());
            }
        });
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

