/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Location")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Location")
public class Location {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String addressCountry;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String addressRegion;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;

    @Schema(description="The organization's country. This follows the [`addressCountry`](https://schema.org/addressCountry) specification.")
    public String getAddressCountry() {
        return this.addressCountry;
    }

    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    @JsonIgnore
    public void setAddressCountry(UnsafeSupplier<String, Exception> addressCountryUnsafeSupplier) {
        try {
            this.addressCountry = (String)addressCountryUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The organization's region. This follows the [`addressRegion`](https://schema.org/addressRegion) specification.")
    public String getAddressRegion() {
        return this.addressRegion;
    }

    public void setAddressRegion(String addressRegion) {
        this.addressRegion = addressRegion;
    }

    @JsonIgnore
    public void setAddressRegion(UnsafeSupplier<String, Exception> addressRegionUnsafeSupplier) {
        try {
            this.addressRegion = (String)addressRegionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The location's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Location)) {
            return false;
        }
        Location location = (Location)object;
        return Objects.equals(this.toString(), location.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.addressCountry != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"addressCountry\": ");
            sb.append("\"");
            sb.append(Location._escape(this.addressCountry));
            sb.append("\"");
        }
        if (this.addressRegion != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"addressRegion\": ");
            sb.append("\"");
            sb.append(Location._escape(this.addressRegion));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

