/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.discovery.internal.jaxrs.application;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.headless.discovery.internal.dto.Hint;
import com.liferay.headless.discovery.internal.dto.Resource;
import com.liferay.headless.discovery.internal.dto.Resources;
import com.liferay.portal.kernel.util.StringUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;
import org.osgi.service.jaxrs.runtime.dto.ApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceMethodInfoDTO;
import org.osgi.service.jaxrs.runtime.dto.RuntimeDTO;

@Component(property={"osgi.jaxrs.application.base=/api", "osgi.jaxrs.extension.select=(osgi.jaxrs.name=Liferay.Vulcan)", "osgi.jaxrs.name=Liferay.Headless.Discovery.API", "auth.verifier.auth.verifier.PortalSessionAuthVerifier.check.csrf.token=false"}, service={Application.class})
public class HeadlessDiscoveryAPIApplication
extends Application {
    @Reference
    private JaxrsServiceRuntime _jaxrsServiceRuntime;
    @Context
    private Providers _providers;
    @Context
    private UriInfo _uriInfo;

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response discovery(@HeaderParam(value="Accept") String accept) throws Exception {
        Map<String, List<ResourceMethodInfoDTO>> resourceMethodInfoDTOsMap = this._getResourceMethodInfoDTOsMap();
        TreeMap<String, Resource> resourcesMap = new TreeMap<String, Resource>();
        for (Map.Entry<String, List<ResourceMethodInfoDTO>> entry : resourceMethodInfoDTOsMap.entrySet()) {
            resourcesMap.put(entry.getKey(), this._getResource(entry.getValue()));
        }
        Resources resources = new Resources(resourcesMap);
        if (accept != null && accept.contains("application/xhtml+xml")) {
            ObjectMapper objectMapper = new ObjectMapper();
            return Response.ok((Object)objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resources), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.ok((Object)resources).build();
    }

    public Set<Object> getSingletons() {
        return Collections.singleton(this);
    }

    private Resource _getResource(List<ResourceMethodInfoDTO> resourceMethodInfoDTOS) {
        Resource resource = new Resource();
        Stream stream = resourceMethodInfoDTOS.stream();
        String[] verbs = (String[])stream.map(dto -> dto.method).toArray(String[]::new);
        ResourceMethodInfoDTO resourceMethodInfoDTO = resourceMethodInfoDTOS.get(0);
        resource.setHint(new Hint(verbs, resourceMethodInfoDTO.producingMimeType));
        String resourcePath = resourceMethodInfoDTO.path;
        if (resourcePath.contains("{")) {
            resource.setHrefTemplate(resourcePath);
        } else {
            resource.setHref(resourcePath);
        }
        return resource;
    }

    private Map<String, List<ResourceMethodInfoDTO>> _getResourceMethodInfoDTOsMap() {
        TreeMap<String, List<ResourceMethodInfoDTO>> resourcesMap = new TreeMap<String, List<ResourceMethodInfoDTO>>();
        URI uri = this._uriInfo.getAbsolutePath();
        String absolutePath = uri.toString();
        String serverURL = StringUtil.removeSubstring((String)absolutePath, (String)"/api/");
        RuntimeDTO runtimeDTO = this._jaxrsServiceRuntime.getRuntimeDTO();
        for (ApplicationDTO applicationDTO : runtimeDTO.applicationDTOs) {
            for (ResourceDTO resourceDTO : applicationDTO.resourceDTOs) {
                for (ResourceMethodInfoDTO resourceMethodInfoDTO : resourceDTO.resourceMethods) {
                    resourceMethodInfoDTO.path = applicationDTO.base + resourceMethodInfoDTO.path;
                    String path = serverURL + resourceMethodInfoDTO.path;
                    ArrayList<ResourceMethodInfoDTO> resourceMethodInfoDTOS = (ArrayList<ResourceMethodInfoDTO>)resourcesMap.get(path);
                    if (resourceMethodInfoDTOS == null) {
                        resourceMethodInfoDTOS = new ArrayList<ResourceMethodInfoDTO>();
                    }
                    resourceMethodInfoDTOS.add(resourceMethodInfoDTO);
                    resourcesMap.put(path, resourceMethodInfoDTOS);
                }
            }
        }
        return resourcesMap;
    }
}

