/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.discovery.internal.jaxrs.application;

import com.liferay.portal.kernel.util.StringUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;
import org.osgi.service.jaxrs.runtime.dto.ApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceMethodInfoDTO;
import org.osgi.service.jaxrs.runtime.dto.RuntimeDTO;

@Component(property={"osgi.jaxrs.application.base=/openapi", "osgi.jaxrs.extension.select=(osgi.jaxrs.name=Liferay.Vulcan)", "osgi.jaxrs.name=Liferay.Headless.Discovery.OpenAPI", "auth.verifier.auth.verifier.PortalSessionAuthVerifier.check.csrf.token=false"}, service={Application.class})
public class HeadlessDiscoveryOpenAPIApplication
extends Application {
    @Reference
    private JaxrsServiceRuntime _jaxrsServiceRuntime;
    @Context
    private UriInfo _uriInfo;

    public Set<Object> getSingletons() {
        return Collections.singleton(this);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Map<String, List<String>> openAPI(@HeaderParam(value="Accept") String accept) {
        TreeMap<String, List<String>> pathsMap = new TreeMap<String, List<String>>();
        URI uri = this._uriInfo.getAbsolutePath();
        String absolutePath = uri.toString();
        String serverURL = StringUtil.removeSubstring((String)absolutePath, (String)"/openapi/");
        RuntimeDTO runtimeDTO = this._jaxrsServiceRuntime.getRuntimeDTO();
        for (ApplicationDTO applicationDTO : runtimeDTO.applicationDTOs) {
            ArrayList<String> paths = new ArrayList<String>();
            for (ResourceDTO resourceDTO : applicationDTO.resourceDTOs) {
                for (ResourceMethodInfoDTO resourceMethodInfoDTO : resourceDTO.resourceMethods) {
                    String path = resourceMethodInfoDTO.path;
                    if (!path.contains("/openapi")) continue;
                    String openAPIPath = StringUtil.replace((String)resourceMethodInfoDTO.path, (String)"{type:json|yaml}", (String)"yaml");
                    paths.add(serverURL + applicationDTO.base + openAPIPath);
                }
            }
            if (paths.isEmpty()) continue;
            String baseURL = applicationDTO.base;
            if (accept != null && accept.contains("application/xml")) {
                baseURL = baseURL.substring(1);
            }
            pathsMap.put(baseURL, paths);
        }
        return pathsMap;
    }
}

