/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.site.internal.resource.v1_0;

import com.liferay.headless.site.dto.v1_0.Site;
import com.liferay.headless.site.internal.resource.v1_0.BaseSiteResourceImpl;
import com.liferay.headless.site.resource.v1_0.SiteResource;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerRegistry;
import com.liferay.sites.kernel.util.Sites;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site.properties"}, scope=ServiceScope.PROTOTYPE, service={SiteResource.class})
public class SiteResourceImpl
extends BaseSiteResourceImpl {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupService _groupService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private SiteInitializerRegistry _siteInitializerRegistry;
    @Reference
    private Sites _sites;

    @Override
    public Site postSite(Site site) throws Exception {
        try {
            final Group group = this._addGroup(site);
            return new Site(){
                {
                    this.friendlyUrlPath = group.getFriendlyURL();
                    this.id = group.getGroupId();
                    this.key = group.getGroupKey();
                    this.name = group.getName(LocaleUtil.getDefault());
                }
            };
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }

    private Group _addGroup(Site site) throws Exception {
        if (Validator.isNull((String)site.getTemplateKey()) && Validator.isNotNull((Object)site.getTemplateType())) {
            throw new IllegalArgumentException("Template key cannot be empty if template type is specified");
        }
        if (Validator.isNotNull((String)site.getTemplateKey()) && Validator.isNull((Object)site.getTemplateType())) {
            throw new IllegalArgumentException("Template type cannot be empty if template key is specified");
        }
        if (Objects.equals(Site.TemplateType.SITE_INITIALIZER, site.getTemplateType())) {
            SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(site.getTemplateKey());
            if (siteInitializer == null) {
                throw new IllegalArgumentException("No site initializer was found for site template key " + site.getTemplateKey());
            }
            if (!siteInitializer.isActive(this.contextCompany.getCompanyId())) {
                throw new IllegalArgumentException("Site initializer with site template key " + site.getTemplateKey() + " is inactive");
            }
        } else if (Objects.equals(Site.TemplateType.SITE_TEMPLATE, site.getTemplateType())) {
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.fetchLayoutSetPrototype(GetterUtil.getLongStrict((String)site.getTemplateKey()));
            if (layoutSetPrototype == null) {
                throw new IllegalArgumentException("No site template found for site template key " + site.getTemplateKey());
            }
            if (!layoutSetPrototype.isActive()) {
                throw new IllegalArgumentException("Site template with site template key " + site.getTemplateKey() + " is inactive");
            }
        }
        ServiceContext serviceContext = new ServiceContext(){
            {
                this.setCompanyId(SiteResourceImpl.this.contextCompany.getCompanyId());
                this.setLanguageId(LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
                this.setUserId(SiteResourceImpl.this.contextUser.getUserId());
            }
        };
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            Group group = this._addGroup(site, serviceContext);
            return group;
        }
        catch (Exception exception) {
            PermissionCacheUtil.clearCache((long[])new long[]{this.contextUser.getUserId()});
            throw exception;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private Group _addGroup(Site site, ServiceContext serviceContext) throws Exception {
        long parentGroupId = 0L;
        if (Validator.isNotNull((String)site.getParentSiteKey())) {
            Group parentGroup = this._groupLocalService.getGroup(this.contextCompany.getCompanyId(), site.getParentSiteKey());
            parentGroupId = parentGroup.getGroupId();
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        if (Validator.isNotNull((String)site.getName())) {
            nameMap.put(LocaleUtil.getDefault(), site.getName());
        }
        int type = 1;
        Site.MembershipType membershipType = site.getMembershipType();
        if (membershipType != null) {
            if (membershipType.equals((Object)Site.MembershipType.PRIVATE)) {
                type = 3;
            } else if (membershipType.equals((Object)Site.MembershipType.RESTRICTED)) {
                type = 2;
            }
        }
        Group group = this._groupService.addGroup(parentGroupId, 0L, nameMap, null, type, true, 0, null, true, false, true, serviceContext);
        LiveUsers.joinGroup((long)this.contextCompany.getCompanyId(), (long)group.getGroupId(), (long)this.contextUser.getUserId());
        if (Objects.equals(Site.TemplateType.SITE_TEMPLATE, site.getTemplateType())) {
            this._sites.updateLayoutSetPrototypesLinks(group, GetterUtil.getLongStrict((String)site.getTemplateKey()), 0L, true, false);
        } else {
            String siteInitializerKey = "blank-site-initializer";
            if (Validator.isNotNull((String)site.getTemplateKey())) {
                siteInitializerKey = site.getTemplateKey();
            }
            SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(siteInitializerKey);
            siteInitializer.initialize(group.getGroupId());
        }
        return group;
    }
}

