/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.field;

import com.liferay.info.field.InfoField;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.petra.string.StringBundler;
import java.util.Locale;
import java.util.function.Supplier;

public class InfoFieldValue<T> {
    private final InfoField _infoField;
    private final T _value;
    private final Supplier<T> _valueSupplier;

    public InfoFieldValue(InfoField infoField, Supplier<T> valueSupplier) {
        this._infoField = infoField;
        this._valueSupplier = valueSupplier;
        this._value = null;
    }

    public InfoFieldValue(InfoField infoField, T value) {
        this._infoField = infoField;
        this._value = value;
        this._valueSupplier = null;
    }

    public InfoField getInfoField() {
        return this._infoField;
    }

    public T getValue() {
        if (this._valueSupplier != null) {
            return this._valueSupplier.get();
        }
        return this._value;
    }

    public T getValue(Locale locale) {
        T value = this.getValue();
        if (value instanceof InfoLocalizedValue) {
            InfoLocalizedValue infoLocalizedValue = (InfoLocalizedValue)value;
            return infoLocalizedValue.getValue(locale);
        }
        return value;
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{", this._infoField.getName(), ": ", this._value, "}"});
    }
}

