/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.type;

import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;

public class WebImage {
    private InfoLocalizedValue<String> _altInfoLocalizedValue;
    private InfoItemReference _infoItemReference;
    private final String _url;

    public WebImage(String url) {
        this._url = url;
    }

    public WebImage(String url, InfoItemReference infoItemReference) {
        this(url);
        this._infoItemReference = infoItemReference;
    }

    public String getAlt() {
        if (this._altInfoLocalizedValue != null) {
            return this._altInfoLocalizedValue.getValue(LocaleUtil.getDefault());
        }
        return "";
    }

    public InfoLocalizedValue<String> getAltInfoLocalizedValue() {
        return this._altInfoLocalizedValue;
    }

    public InfoItemReference getInfoItemReference() {
        return this._infoItemReference;
    }

    public String getURL() {
        return this._url;
    }

    public WebImage setAlt(String alt) {
        this._altInfoLocalizedValue = InfoLocalizedValue.singleValue(alt);
        return this;
    }

    public WebImage setAltInfoLocalizedValue(InfoLocalizedValue<String> altInfoLocalizedValue) {
        this._altInfoLocalizedValue = altInfoLocalizedValue;
        return this;
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(LocaleUtil.getDefault());
    }

    public JSONObject toJSONObject(Locale locale) {
        JSONObject jsonObject = JSONUtil.put((String)"url", (Object)this._url);
        if (this._altInfoLocalizedValue != null) {
            jsonObject.put("alt", this._altInfoLocalizedValue.getValue(locale));
        }
        if (this._infoItemReference != null) {
            jsonObject.put("className", this._infoItemReference.getClassName());
            InfoItemIdentifier infoItemIdentifier = this._infoItemReference.getInfoItemIdentifier();
            if (infoItemIdentifier instanceof ClassPKInfoItemIdentifier) {
                ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemIdentifier;
                jsonObject.put("classPK", classPKInfoItemIdentifier.getClassPK());
            }
        }
        return jsonObject;
    }

    public String toString() {
        return this.getURL();
    }
}

