/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.exception;

import com.liferay.info.item.capability.InfoItemCapability;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CapabilityVerificationException
extends RuntimeException {
    private final InfoItemCapability _infoItemCapability;
    private final String _infoItemClassName;
    private final List<Class<?>> _missingServiceClasses;

    public CapabilityVerificationException(InfoItemCapability infoItemCapability, String infoItemClassName, List<Class<?>> missingServiceClasses) {
        this._infoItemCapability = infoItemCapability;
        this._infoItemClassName = infoItemClassName;
        this._missingServiceClasses = missingServiceClasses;
    }

    public InfoItemCapability getInfoItemCapability() {
        return this._infoItemCapability;
    }

    public String getInfoItemClassName() {
        return this._infoItemClassName;
    }

    @Override
    public String getMessage() {
        StringBundler sb = new StringBundler(8);
        sb.append("Failed validation of capability ");
        sb.append(this._infoItemCapability.getKey());
        sb.append(" for item class name ");
        sb.append(this._infoItemClassName);
        sb.append(". An implementation for the following services is ");
        sb.append("required: ");
        sb.append(this._getMissingServiceClassNames());
        sb.append(".");
        return sb.toString();
    }

    public List<Class<?>> getMissingServiceClasses() {
        return this._missingServiceClasses;
    }

    private String _getMissingServiceClassNames() {
        Stream stream = this._missingServiceClasses.stream();
        return stream.map(clazz -> clazz.getName()).collect(Collectors.joining(", "));
    }
}

