/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.field;

import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class InfoField<T extends InfoFieldType>
implements InfoFieldSetEntry {
    private final Builder _builder;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public InfoField(T infoFieldType, InfoLocalizedValue<String> labelInfoLocalizedValue, boolean localizable, String name) {
        this(((FinalStep)InfoField.builder().infoFieldType(infoFieldType).name(name).labelInfoLocalizedValue(labelInfoLocalizedValue).localizable(localizable))._builder);
    }

    @Deprecated
    public InfoField(T infoFieldType, InfoLocalizedValue<String> labelInfoLocalizedValue, String name) {
        this(((FinalStep)InfoField.builder().infoFieldType(infoFieldType).name(name).labelInfoLocalizedValue(labelInfoLocalizedValue))._builder);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InfoField)) {
            return false;
        }
        InfoField infoDisplayField = (InfoField)object;
        return Objects.equals(this._builder._infoFieldType, infoDisplayField._builder._infoFieldType) && Objects.equals(this._builder._labelInfoLocalizedValue, infoDisplayField._builder._labelInfoLocalizedValue) && Objects.equals(this._builder._name, infoDisplayField._builder._name);
    }

    public <V> Optional<V> getAttributeOptional(InfoFieldType.Attribute<T, V> attribute) {
        return Optional.ofNullable(this._builder._attributes.get(attribute));
    }

    public InfoFieldType getInfoFieldType() {
        return this._builder._infoFieldType;
    }

    @Override
    public String getLabel(Locale locale) {
        return (String)this._builder._labelInfoLocalizedValue.getValue(locale);
    }

    @Override
    public InfoLocalizedValue<String> getLabelInfoLocalizedValue() {
        return this._builder._labelInfoLocalizedValue;
    }

    @Override
    public String getName() {
        return this._builder._name;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (Object)this._builder._infoFieldType);
        hash = HashUtil.hash((int)hash, (Object)this._builder._labelInfoLocalizedValue);
        return HashUtil.hash((int)hash, (Object)this._builder._name);
    }

    public boolean isLocalizable() {
        return this._builder._localizable;
    }

    public boolean isMultivalued() {
        return this._builder._multivalued;
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{name: ");
        sb.append(this._builder._name);
        sb.append(", type: ");
        sb.append(this._builder._infoFieldType.getName());
        sb.append("}");
        return sb.toString();
    }

    private InfoField(Builder builder) {
        this._builder = builder;
    }

    public static class NameStep<T extends InfoFieldType> {
        private final Builder _builder;

        public FinalStep<T> name(String name) {
            this._builder._name = name;
            return new FinalStep(this._builder);
        }

        private NameStep(Builder builder) {
            this._builder = builder;
        }
    }

    public static class FinalStep<T extends InfoFieldType> {
        private final Builder _builder;

        public <V> FinalStep<T> attribute(InfoFieldType.Attribute<T, V> attribute, V value) {
            this._builder._attributes.put(attribute, value);
            return this;
        }

        public InfoField<T> build() {
            if (this._builder._labelInfoLocalizedValue == null) {
                this._builder._labelInfoLocalizedValue = InfoLocalizedValue.localize(InfoField.class, this._builder._name);
            }
            return new InfoField(this._builder);
        }

        public FinalStep<T> labelInfoLocalizedValue(InfoLocalizedValue<String> labelInfoLocalizedValue) {
            this._builder._labelInfoLocalizedValue = labelInfoLocalizedValue;
            return this;
        }

        public FinalStep<T> localizable(boolean localizable) {
            this._builder._localizable = localizable;
            return this;
        }

        public FinalStep<T> multivalued(boolean multivalued) {
            this._builder._multivalued = multivalued;
            return this;
        }

        private FinalStep(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private final Map<InfoFieldType.Attribute<? extends InfoFieldType, ?>, Object> _attributes = new HashMap();
        private InfoFieldType _infoFieldType;
        private InfoLocalizedValue<String> _labelInfoLocalizedValue;
        private boolean _localizable;
        private boolean _multivalued;
        private String _name;

        public <T extends InfoFieldType> NameStep<T> infoFieldType(T infoFieldType) {
            this._infoFieldType = infoFieldType;
            return new NameStep(this);
        }

        private Builder() {
        }
    }
}

