/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.invitation.web.internal.portlet.action;

import com.liferay.invitation.web.internal.util.InvitationUtil;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_invitation_web_portlet_InvitationPortlet", "mvc.command.name=view"}, service={MVCActionCommand.class})
public class ViewMVCActionCommand
extends BaseMVCActionCommand {
    private MailService _mailService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String body;
        HashSet<String> invalidEmailAddresses = new HashSet<String>();
        HashSet<String> validEmailAddresses = new HashSet<String>();
        PortletPreferences portletPreferences = actionRequest.getPreferences();
        int emailMessageMaxRecipients = InvitationUtil.getEmailMessageMaxRecipients(portletPreferences);
        for (int i = 0; i < emailMessageMaxRecipients; ++i) {
            String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)("emailAddress" + i));
            if (Validator.isEmailAddress((String)emailAddress)) {
                validEmailAddresses.add(emailAddress);
                continue;
            }
            if (!Validator.isNotNull((String)emailAddress)) continue;
            invalidEmailAddresses.add("emailAddress" + i);
        }
        if (validEmailAddresses.isEmpty() && invalidEmailAddresses.isEmpty()) {
            invalidEmailAddresses.add("emailAddress0");
        }
        if (!invalidEmailAddresses.isEmpty()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailAddresses", invalidEmailAddresses);
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        String fromAddress = user.getEmailAddress();
        String fromName = user.getFullName();
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        Layout layout = themeDisplay.getLayout();
        String portalURL = PortalUtil.getPortalURL((PortletRequest)actionRequest);
        String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)themeDisplay);
        Map<Locale, String> localizedSubjectMap = InvitationUtil.getEmailMessageSubjectMap(portletPreferences);
        Map<Locale, String> localizedBodyMap = InvitationUtil.getEmailMessageBodyMap(portletPreferences);
        Locale locale = user.getLocale();
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String subject = localizedSubjectMap.get(locale);
        if (Validator.isNull((String)subject)) {
            subject = localizedSubjectMap.get(defaultLocale);
        }
        if (Validator.isNull((String)(body = localizedBodyMap.get(locale)))) {
            body = localizedBodyMap.get(defaultLocale);
        }
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PAGE_URL$]", "[$PORTAL_URL$]"}, (String[])new String[]{fromAddress, fromName, layoutFullURL, portalURL});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PAGE_URL$]", "[$PORTAL_URL$]"}, (String[])new String[]{fromAddress, fromName, layoutFullURL, portalURL});
        for (String emailAddress : validEmailAddresses) {
            InternetAddress to = new InternetAddress(emailAddress);
            MailMessage message = new MailMessage(from, to, subject, body, true);
            Company company = themeDisplay.getCompany();
            message.setMessageId(PortalUtil.getMailId((String)company.getMx(), (String)"invitation", (Object[])new Object[]{PortalUUIDUtil.generate()}));
            this._mailService.sendEmail(message);
        }
        SessionMessages.add((PortletRequest)actionRequest, (String)"invitationSent");
        String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
        if (Validator.isNotNull((String)redirect)) {
            actionResponse.setRenderParameter("mvcPath", redirect);
        }
        actionResponse.setRenderParameter("mvcPath", "/view.jsp");
    }

    @Reference(unbind="-")
    protected void setMailService(MailService mailService) {
        this._mailService = mailService;
    }
}

