/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.invitation.web.internal.util;

import com.liferay.petra.content.ContentUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class InvitationUtil {
    public static final String MESSAGE_POP_PORTLET_PREFIX = "invitation";

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$FROM_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-sender"));
        definitionTerms.put("[$FROM_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-sender"));
        definitionTerms.put("[$PAGE_URL$]", PortalUtil.getLayoutFullURL((Layout)themeDisplay.getLayout(), (ThemeDisplay)themeDisplay));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        return definitionTerms;
    }

    public static Map<Locale, String> getEmailMessageBodyMap(PortletPreferences preferences) {
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailMessageBody");
        String value = (String)map.get(LocaleUtil.getDefault());
        if (Validator.isNull((String)value)) {
            map.put(LocaleUtil.getDefault(), ContentUtil.get((ClassLoader)InvitationUtil.class.getClassLoader(), (String)"com/liferay/invitation/web/util/dependencies/email_message_body.tmpl"));
        }
        return map;
    }

    public static String getEmailMessageBodyXml(PortletPreferences preferences, PortletRequest portletRequest, String prefix) {
        return LocalizationUtil.getLocalizationXmlFromPreferences((PortletPreferences)preferences, (PortletRequest)portletRequest, (String)"emailMessageBody", (String)prefix, (String)ContentUtil.get((ClassLoader)InvitationUtil.class.getClassLoader(), (String)"com/liferay/invitation/web/util/dependencies/email_message_body.tmpl"));
    }

    public static int getEmailMessageMaxRecipients(PortletPreferences portletPreferences) {
        return GetterUtil.getInteger((String)portletPreferences.getValue("emailMaxRecipients", ""));
    }

    public static Map<Locale, String> getEmailMessageSubjectMap(PortletPreferences preferences) {
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailMessageSubject");
        String value = (String)map.get(LocaleUtil.getDefault());
        if (Validator.isNull((String)value)) {
            map.put(LocaleUtil.getDefault(), ContentUtil.get((ClassLoader)InvitationUtil.class.getClassLoader(), (String)"com/liferay/invitation/web/util/dependencies/email_message_subject.tmpl"));
        }
        return map;
    }

    public static String getEmailMessageSubjectXml(PortletPreferences preferences, PortletRequest portletRequest, String prefix) {
        return LocalizationUtil.getLocalizationXmlFromPreferences((PortletPreferences)preferences, (PortletRequest)portletRequest, (String)"emailMessageSubject", (String)prefix, (String)ContentUtil.get((ClassLoader)InvitationUtil.class.getClassLoader(), (String)"com/liferay/invitation/web/util/dependencies/email_message_subject.tmpl"));
    }
}

