/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.javadoc.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import com.liferay.util.xml.Dom4jDocUtil;
import com.liferay.util.xml.Dom4jUtil;
import com.liferay.util.xml.XMLSafeReader;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class JavadocFormatter {
    private final String _author;
    private final boolean _generateXml;
    private String _imports;
    private final boolean _initializeMissingJavadocs;
    private final String _inputDirName;
    private JavaDocBuilder _javadocBuilder;
    private final Map<String, Tuple> _javadocxXmlTuples = new HashMap<String, Tuple>();
    private final Properties _languageProperties;
    private final File _languagePropertiesFile;
    private final Set<String> _modifiedFileNames = new HashSet<String>();
    private final String _outputFilePrefix;
    private String _packagePath;
    private final Pattern _paragraphTagPattern = Pattern.compile("(^.*?(?=\n\n|$)+|(?<=<p>\n).*?(?=\n</p>))", 32);
    private final boolean _updateJavadocs;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            new JavadocFormatter(arguments);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public JavadocFormatter(Map<String, String> arguments) throws Exception {
        String outputFilePrefix;
        File languagePropertiesFile;
        String author;
        this._author = author = ArgumentsUtil.getString(arguments, "javadoc.author", "Brian Wing Shun Chan");
        this._generateXml = GetterUtil.getBoolean(arguments.get("javadoc.generate.xml"));
        String init = arguments.get("javadoc.init");
        this._initializeMissingJavadocs = GetterUtil.getBoolean(init);
        String inputDirName = ArgumentsUtil.getString(arguments, "javadoc.input.dir", "./");
        if (!inputDirName.endsWith("/")) {
            inputDirName = inputDirName + "/";
        }
        this._inputDirName = inputDirName;
        System.out.println("Input directory is " + this._inputDirName);
        String[] limits = StringUtil.split(arguments.get("javadoc.limit"), ",");
        if (limits.length == 0) {
            limits = new String[]{""};
        }
        if (!(languagePropertiesFile = new File("src/content/Language.properties")).exists()) {
            languagePropertiesFile = new File("src/main/resources/content/Language.properties");
        }
        if (languagePropertiesFile.exists()) {
            this._languageProperties = new Properties();
            this._languagePropertiesFile = languagePropertiesFile;
            this._languageProperties.load(new FileInputStream(this._languagePropertiesFile.getAbsolutePath()));
        } else {
            this._languageProperties = null;
            this._languagePropertiesFile = null;
        }
        this._outputFilePrefix = outputFilePrefix = ArgumentsUtil.getString(arguments, "javadoc.output.file.prefix", "javadocs");
        this._updateJavadocs = GetterUtil.getBoolean(arguments.get("javadoc.update"));
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this._inputDirName);
        directoryScanner.setExcludes(new String[]{"**\\build\\**", "**\\classes\\**", "**\\portal-client\\**"});
        for (String limit : limits) {
            ArrayList<String> includes = new ArrayList<String>();
            if (Validator.isNotNull(limit) && !limit.startsWith("$")) {
                String[] limitArray;
                System.out.println("Limit on " + limit);
                for (String string : limitArray = StringUtil.split(limit, '/')) {
                    includes.add("**\\" + StringUtil.replace(string, '.', '\\') + "\\**\\*.java");
                    includes.add("**\\" + string + ".java");
                }
            } else {
                includes.add("**\\*.java");
            }
            directoryScanner.setIncludes(includes.toArray(new String[includes.size()]));
            directoryScanner.scan();
            String[] fileNames = StringPool.EMPTY_ARRAY;
            fileNames = directoryScanner.getIncludedFiles();
            if (fileNames.length == 0 && Validator.isNotNull(limit) && !limit.startsWith("$")) {
                StringBundler sb = new StringBundler("Limit file not found: ");
                sb.append(limit);
                if (limit.contains(".")) {
                    sb.append(" Specify limit filename without package path or ");
                    sb.append("file type suffix.");
                }
                System.out.println(sb.toString());
            }
            this._populateJavadocBuilder(fileNames);
            for (String string : fileNames) {
                String string2 = StringUtil.replace(string, '\\', '/');
                try {
                    this._format(string2);
                }
                catch (Exception e) {
                    if (e instanceof ParseException) {
                        if (string2.contains("/tools/templates/")) continue;
                        System.out.println("Qdox parsing error while formatting file " + string2);
                        continue;
                    }
                    throw new RuntimeException("Unable to format file " + string2, e);
                }
            }
        }
        if (this._generateXml) {
            for (Map.Entry entry : this._javadocxXmlTuples.entrySet()) {
                String newJavadocsRuntimeXmlContent;
                void var18_31;
                Tuple tuple = (Tuple)entry.getValue();
                File javadocsXmlFile = (File)tuple.getObject(1);
                String oldJavadocsXmlContent = (String)tuple.getObject(2);
                Document javadocsXmlDocument = (Document)tuple.getObject(3);
                Element javadocsXmlRootElement = javadocsXmlDocument.getRootElement();
                this._sortElementsByChildElement(javadocsXmlRootElement, "javadoc", "type");
                String newJavadocsXmlContent = this._formattedString((Node)javadocsXmlDocument);
                if (!oldJavadocsXmlContent.equals(newJavadocsXmlContent)) {
                    this._write(javadocsXmlFile, newJavadocsXmlContent);
                    this._modifiedFileNames.add(javadocsXmlFile.getAbsolutePath());
                }
                this._detachUnnecessaryTypes(javadocsXmlRootElement);
                File javadocsRuntimeXmlFile = new File(StringUtil.replaceLast(javadocsXmlFile.toString(), "-all.xml", "-rt.xml"));
                String string = "";
                if (javadocsRuntimeXmlFile.exists()) {
                    String string3 = this._read(javadocsRuntimeXmlFile);
                }
                if (var18_31.equals(newJavadocsRuntimeXmlContent = this._compactString((Node)javadocsXmlDocument))) continue;
                this._write(javadocsRuntimeXmlFile, newJavadocsRuntimeXmlContent);
                this._modifiedFileNames.add(javadocsRuntimeXmlFile.getAbsolutePath());
            }
        }
    }

    public Set<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    private void _addClassCommentElement(Element rootElement, JavaClass javaClass) {
        String comment = this._getCDATA((AbstractJavaEntity)javaClass);
        if (comment.startsWith("Copyright (c)")) {
            comment = "";
        }
        if (Validator.isNull(comment)) {
            return;
        }
        Element commentElement = rootElement.addElement("comment");
        commentElement.addCDATA(comment);
    }

    private String _addDeprecatedTag(String comment, AbstractBaseJavaEntity abstractBaseJavaEntity, String indent) throws Exception {
        if (comment == null) {
            return null;
        }
        if (!(comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath)).contains("* @deprecated ") || this._hasAnnotation(abstractBaseJavaEntity, "Deprecated")) {
            return comment;
        }
        return comment + indent + "@Deprecated\n";
    }

    private void _addDocletElements(Element parentElement, AbstractJavaEntity abstractJavaEntity, String name) throws Exception {
        DocletTag[] docletTags;
        for (DocletTag docletTag : docletTags = abstractJavaEntity.getTagsByName(name)) {
            String value = docletTag.getValue();
            value = ToolsUtil.stripFullyQualifiedClassNames(value, this._imports, this._packagePath);
            value = this._trimMultilineText(value);
            value = StringUtil.replace(value, " </", "</");
            Element element = parentElement.addElement(name);
            element.addCDATA(value);
        }
        if (docletTags.length == 0 && name.equals("author")) {
            Element element = parentElement.addElement(name);
            element.addCDATA(this._author);
        }
    }

    private String _addDocletTags(Element parentElement, String[] tagNames, String indent, boolean publicAccess) {
        ArrayList<String> allTagNames = new ArrayList<String>();
        ArrayList<String> customTagNames = new ArrayList<String>();
        ArrayList<String> requiredTagNames = new ArrayList<String>();
        for (String tagName : tagNames) {
            List elements = parentElement.elements(tagName);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                if (tagName.equals("param") || tagName.equals("return") || tagName.equals("throws")) {
                    if (Validator.isNotNull(comment)) {
                        requiredTagNames.add(tagName);
                    } else if (tagName.equals("param")) {
                        if (GetterUtil.getBoolean(element.elementText("required"))) {
                            requiredTagNames.add(tagName);
                        }
                    } else if (tagName.equals("throws") && GetterUtil.getBoolean(element.elementText("required"))) {
                        requiredTagNames.add(tagName);
                    }
                } else {
                    customTagNames.add(tagName);
                }
                allTagNames.add(tagName);
            }
        }
        int maxTagNameLength = 0;
        ArrayList<String> maxTagNameLengthTags = new ArrayList<String>();
        if (this._initializeMissingJavadocs) {
            maxTagNameLengthTags.addAll(allTagNames);
        } else if (this._updateJavadocs) {
            if (!requiredTagNames.isEmpty()) {
                maxTagNameLengthTags.addAll(allTagNames);
            } else {
                maxTagNameLengthTags.addAll(customTagNames);
                maxTagNameLengthTags.addAll(requiredTagNames);
            }
        } else {
            maxTagNameLengthTags.addAll(customTagNames);
            maxTagNameLengthTags.addAll(requiredTagNames);
        }
        for (String name : maxTagNameLengthTags) {
            if (name.length() <= maxTagNameLength) continue;
            maxTagNameLength = name.length();
        }
        String tagNameIndent = this._getSpacesIndent(maxTagNameLength += 2);
        StringBundler sb = new StringBundler();
        for (String tagName : tagNames) {
            List elements = parentElement.elements(tagName);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                String elementName = element.elementText("name");
                if (Validator.isNotNull(comment)) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (this._initializeMissingJavadocs && publicAccess) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (this._updateJavadocs && publicAccess) {
                    if (!(tagName.equals("param") || tagName.equals("return") || tagName.equals("throws"))) {
                        comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                        sb.append(comment);
                        continue;
                    }
                    if (requiredTagNames.isEmpty()) continue;
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (!(tagName.equals("param") || tagName.equals("return") || tagName.equals("throws"))) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (!tagName.equals("param") && !tagName.equals("return") && !tagName.equals("throws") || !GetterUtil.getBoolean(element.elementText("required"))) continue;
                elementName = element.elementText("name");
                comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                sb.append(comment);
            }
        }
        return sb.toString();
    }

    private void _addFieldElement(Element rootElement, JavaField javaField) throws Exception {
        Element fieldElement = rootElement.addElement("field");
        Dom4jDocUtil.add(fieldElement, "name", javaField.getName());
        String comment = this._getCDATA((AbstractJavaEntity)javaField);
        if (Validator.isNotNull(comment)) {
            Element commentElement = fieldElement.addElement("comment");
            commentElement.addCDATA(comment);
        }
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "version");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "see");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "since");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "deprecated");
    }

    private void _addMethodElement(Element rootElement, JavaMethod javaMethod) throws Exception {
        Element methodElement = rootElement.addElement("method");
        Dom4jDocUtil.add(methodElement, "name", javaMethod.getName());
        String comment = this._getCDATA((AbstractJavaEntity)javaMethod);
        if (Validator.isNotNull(comment)) {
            Element commentElement = methodElement.addElement("comment");
            commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaMethod));
        }
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "version");
        this._addParamElements(methodElement, javaMethod);
        this._addReturnElement(methodElement, javaMethod);
        this._addThrowsElements(methodElement, javaMethod);
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "see");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "since");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "deprecated");
    }

    private void _addParamElement(Element methodElement, JavaParameter javaParameter, DocletTag[] paramDocletTags) throws Exception {
        String name = javaParameter.getName();
        String value = null;
        for (DocletTag paramDocletTag : paramDocletTags) {
            String curValue = paramDocletTag.getValue();
            if (!curValue.equals(name) && !curValue.startsWith(name + " ")) continue;
            value = curValue;
            break;
        }
        Element paramElement = methodElement.addElement("param");
        Dom4jDocUtil.add(paramElement, "name", name);
        Dom4jDocUtil.add(paramElement, "type", this._getTypeValue(javaParameter));
        if (value != null) {
            value = value.substring(name.length());
            Dom4jDocUtil.add(paramElement, "required", true);
        }
        value = ToolsUtil.stripFullyQualifiedClassNames(value, this._imports, this._packagePath);
        value = this._trimMultilineText(value);
        Element commentElement = paramElement.addElement("comment");
        commentElement.addCDATA(value);
    }

    private void _addParamElements(Element methodElement, JavaMethod javaMethod) throws Exception {
        JavaParameter[] javaParameters = javaMethod.getParameters();
        DocletTag[] paramDocletTags = javaMethod.getTagsByName("param");
        for (JavaParameter javaParameter : javaParameters) {
            this._addParamElement(methodElement, javaParameter, paramDocletTags);
        }
    }

    private void _addReturnElement(Element methodElement, JavaMethod javaMethod) throws Exception {
        Type returnType = javaMethod.getReturnType();
        if (returnType == null) {
            return;
        }
        String returnTypeValue = returnType.getValue();
        if (returnTypeValue.equals("void")) {
            return;
        }
        Element returnElement = methodElement.addElement("return");
        DocletTag[] returnDocletTags = javaMethod.getTagsByName("return");
        String comment = "";
        if (returnDocletTags.length > 0) {
            DocletTag returnDocletTag = returnDocletTags[0];
            comment = GetterUtil.getString(returnDocletTag.getValue());
            Dom4jDocUtil.add(returnElement, "required", true);
        }
        comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath);
        comment = this._trimMultilineText(comment);
        Element commentElement = returnElement.addElement("comment");
        commentElement.addCDATA(comment);
    }

    private void _addThrowsElement(Element methodElement, Type exceptionType, DocletTag[] throwsDocletTags) throws Exception {
        JavaClass javaClass = exceptionType.getJavaClass();
        String name = javaClass.getName();
        String value = null;
        for (DocletTag throwsDocletTag : throwsDocletTags) {
            String curValue = throwsDocletTag.getValue();
            if (!curValue.startsWith(name)) continue;
            value = curValue;
            break;
        }
        Element throwsElement = methodElement.addElement("throws");
        Dom4jDocUtil.add(throwsElement, "name", name);
        Dom4jDocUtil.add(throwsElement, "type", exceptionType.getValue());
        if (value != null) {
            value = value.substring(name.length());
            Dom4jDocUtil.add(throwsElement, "required", true);
        }
        value = ToolsUtil.stripFullyQualifiedClassNames(value, this._imports, this._packagePath);
        value = this._trimMultilineText(value);
        Element commentElement = throwsElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addThrowsElements(Element methodElement, JavaMethod javaMethod) throws Exception {
        Type[] exceptionTypes = javaMethod.getExceptions();
        DocletTag[] throwsDocletTags = javaMethod.getTagsByName("throws");
        for (Type exceptionType : exceptionTypes) {
            this._addThrowsElement(methodElement, exceptionType, throwsDocletTags);
        }
    }

    private String _assembleTagComment(String tagName, String elementName, String comment, String indent, String tagNameIndent) {
        String indentAndTagName = indent + "@" + tagName;
        if (Validator.isNotNull(elementName)) {
            comment = Validator.isNotNull(comment) ? elementName + " " + comment : elementName;
            comment = this._wrapText(comment, indent + tagNameIndent);
            comment = indentAndTagName + comment.substring(indentAndTagName.length());
        } else if (Validator.isNotNull(comment)) {
            comment = this._wrapText(comment, indent + tagNameIndent);
            comment = indentAndTagName + comment.substring(indentAndTagName.length());
        } else {
            comment = indentAndTagName + "\n";
        }
        return comment;
    }

    private String _compactString(Node node) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        OutputFormat outputFormat = OutputFormat.createCompactFormat();
        XMLWriter xmlWriter = new XMLWriter((OutputStream)unsyncByteArrayOutputStream, outputFormat);
        xmlWriter.write(node);
        return unsyncByteArrayOutputStream.toString("UTF-8");
    }

    private void _detachUnnecessaryTypes(Element rootElement) {
        List elements = rootElement.elements();
        for (Element element : elements) {
            String type = element.elementText("type");
            if (type.contains(".service.") && type.endsWith("ServiceImpl")) continue;
            element.detach();
        }
    }

    private void _format(String fileName) throws Exception {
        String newContent;
        File file = new File(this._inputDirName, fileName);
        String originalContent = this._read(file);
        String absolutePath = this._getAbsolutePath(fileName);
        if (absolutePath.contains("modules/third-party") || fileName.endsWith("Application.java") || fileName.endsWith("JavadocFormatter.java") || fileName.endsWith("Mojo.java") || fileName.endsWith("SourceFormatter.java") || fileName.endsWith("WebProxyPortlet.java") || this._hasGeneratedTag(originalContent)) {
            return;
        }
        this._imports = JavaImportsFormatter.getImports(originalContent);
        this._packagePath = ToolsUtil.getPackagePath(fileName);
        JavaClass javaClass = this._getJavaClass(fileName, new UnsyncStringReader(originalContent));
        String javadocLessContent = this._removeJavadocFromJava(javaClass, originalContent);
        Document document = this._getJavadocDocument(javaClass);
        if (this._generateXml) {
            this._updateJavadocsXmlFile(fileName, javaClass, document);
        }
        if (!originalContent.equals(newContent = this._getUpdateJavaFromDocument(fileName, javadocLessContent, document))) {
            this._write(file, newContent);
            this._modifiedFileNames.add(file.getAbsolutePath());
            System.out.println("Writing " + file);
        }
    }

    private String _formatCDATA(String cdata) {
        cdata = cdata.replaceAll("(?s)\\s*<(p|[ou]l)>\\s*(.*?)\\s*</\\1>\\s*", "\n\n<$1>\n$2\n</$1>\n\n");
        cdata = cdata.replaceAll("(?s)\\s*<li>\\s*(.*?)\\s*</li>\\s*", "\n<li>\n$1\n</li>\n");
        cdata = StringUtil.replace(cdata, "</li>\n\n<li>", "</li>\n<li>");
        cdata = cdata.replaceAll("\n\\s+\n", "\n\n");
        cdata = cdata.replaceAll(" +", " ");
        Matcher matcher = this._paragraphTagPattern.matcher(cdata);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String trimmed = this._trimMultilineText(matcher.group());
            trimmed = StringUtil.replace(trimmed, '$', "\\$");
            matcher.appendReplacement(sb, trimmed);
        }
        matcher.appendTail(sb);
        cdata = sb.toString();
        return cdata.trim();
    }

    private String _formatInlines(String text) {
        text = text.replaceAll("[?@param id](?i)\\bid(s)?\\b", " ID$1");
        text = text.replaceAll("(?i)(?<!<code>|\\w)(null|false|true)(?!\\w)", "<code>$1</code>");
        return text;
    }

    private String _formattedString(Node node) throws IOException {
        return Dom4jUtil.toString(node);
    }

    private String _getAbsolutePath(String fileName) {
        Path filePath = Paths.get(fileName, new String[0]);
        filePath = filePath.toAbsolutePath();
        filePath = filePath.normalize();
        return StringUtil.replace(filePath.toString(), '\\', '/');
    }

    private String _getCDATA(AbstractJavaEntity abstractJavaEntity) {
        return this._getCDATA(abstractJavaEntity.getComment());
    }

    private String _getCDATA(String cdata) {
        StringBundler sb = new StringBundler();
        if (cdata == null || cdata.isEmpty()) {
            return "";
        }
        int cdataBeginIndex = 0;
        while (!cdata.isEmpty()) {
            int preTagIndex = cdata.indexOf("<pre>");
            int tableTagIndex = cdata.indexOf("<table>");
            boolean hasPreTag = false;
            if (preTagIndex != -1) {
                hasPreTag = true;
            }
            boolean hasTableTag = false;
            if (tableTagIndex != -1) {
                hasTableTag = true;
            }
            if (!hasPreTag && !hasTableTag) {
                sb.append(this._formatCDATA(cdata));
                break;
            }
            boolean startsWithPreTag = false;
            if (preTagIndex == 0) {
                startsWithPreTag = true;
            }
            boolean startsWithTableTag = false;
            if (tableTagIndex == 0) {
                startsWithTableTag = true;
            }
            if (startsWithPreTag || startsWithTableTag) {
                sb.append("\n");
                String tagName = null;
                tagName = preTagIndex == 0 ? "pre" : "table";
                String startTag = "<" + tagName + ">";
                String endTag = "</" + tagName + ">";
                int startTagLength = startTag.length();
                int endTagLength = endTag.length();
                int endTagIndex = cdata.indexOf(endTag, startTagLength - 1);
                sb.append(cdata.substring(0, endTagIndex + endTagLength));
                sb.append("\n");
                cdataBeginIndex = endTagIndex + endTagLength;
            } else {
                int startTagIndex = 0;
                startTagIndex = hasPreTag && hasTableTag ? (preTagIndex < tableTagIndex ? preTagIndex : tableTagIndex) : (hasPreTag && !hasTableTag ? preTagIndex : tableTagIndex);
                sb.append(this._formatCDATA(cdata.substring(0, startTagIndex)));
                cdataBeginIndex = startTagIndex;
            }
            cdata = cdata.substring(cdataBeginIndex);
        }
        cdata = sb.toString();
        return cdata.trim();
    }

    private String _getClassName(String fileName) {
        int pos = fileName.indexOf("src/main/java/");
        if (pos == -1) {
            pos = fileName.indexOf("src/test/java/");
        }
        if (pos == -1) {
            pos = fileName.indexOf("src/testIntegration/java/");
        }
        if (pos != -1) {
            pos = fileName.indexOf("java/", pos);
        }
        if (pos == -1) {
            pos = fileName.indexOf("src/");
        }
        if (pos == -1 && (pos = fileName.indexOf("test/integration/")) != -1) {
            pos = fileName.indexOf("integration/", pos);
        }
        if (pos == -1 && (pos = fileName.indexOf("test/unit/")) != -1) {
            pos = fileName.indexOf("unit/", pos);
        }
        if (pos == -1) {
            pos = fileName.indexOf("test/");
        }
        if (pos == -1) {
            pos = fileName.indexOf("service/");
        }
        if (pos == -1) {
            throw new RuntimeException(fileName);
        }
        pos = fileName.indexOf("/", pos);
        String srcFile = fileName.substring(pos + 1, fileName.length());
        return StringUtil.replace(srcFile.substring(0, srcFile.length() - 5), '/', '.');
    }

    private String _getFieldKey(Element fieldElement) {
        return fieldElement.elementText("name");
    }

    private String _getFieldKey(JavaField javaField) {
        return javaField.getName();
    }

    private String _getIndent(String[] lines, AbstractBaseJavaEntity abstractBaseJavaEntity) {
        String line = lines[abstractBaseJavaEntity.getLineNumber() - 1];
        String indent = "";
        for (char c : line.toCharArray()) {
            if (!Character.isWhitespace(c)) break;
            indent = indent + c;
        }
        return indent;
    }

    private int _getIndentLength(String indent) {
        int indentLength = 0;
        for (char c : indent.toCharArray()) {
            if (c == '\t') {
                indentLength += 4;
                continue;
            }
            ++indentLength;
        }
        return indentLength;
    }

    private JavaClass _getJavaClass(String fileName, Reader reader) throws Exception {
        String className = this._getClassName(fileName);
        if (reader != null) {
            this._javadocBuilder.addSource(reader);
        }
        return this._javadocBuilder.getClassByName(className);
    }

    private String _getJavaClassComment(Element rootElement, JavaClass javaClass) throws Exception {
        String docletTags;
        StringBundler sb = new StringBundler();
        String indent = "";
        sb.append("/**\n");
        String comment = rootElement.elementText("comment");
        if (Validator.isNotNull(comment)) {
            comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath);
            sb.append(this._wrapText(comment, indent + " * "));
        }
        if (Validator.isNotNull(docletTags = this._addDocletTags(rootElement, new String[]{"author", "version", "see", "since", "serial", "deprecated"}, indent + " * ", this._hasPublicModifier((AbstractJavaEntity)javaClass)))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull(comment)) {
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(" */\n");
        return sb.toString();
    }

    private int _getJavaClassLineNumber(JavaClass javaClass) {
        int lineNumber = javaClass.getLineNumber();
        Annotation[] annotations = javaClass.getAnnotations();
        if (annotations.length == 0) {
            return lineNumber;
        }
        for (Annotation annotation : annotations) {
            int annotationLineNumber = annotation.getLineNumber();
            Map propertyMap = annotation.getPropertyMap();
            if (propertyMap.isEmpty()) {
                --annotationLineNumber;
            }
            if (annotationLineNumber >= lineNumber) continue;
            lineNumber = annotationLineNumber;
        }
        return lineNumber;
    }

    private Document _getJavadocDocument(JavaClass javaClass) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        Element rootElement = DocumentHelper.createElement((String)"javadoc");
        Document document = DocumentHelper.createDocument((Element)rootElement);
        Dom4jDocUtil.add(rootElement, "name", javaClass.getName());
        Dom4jDocUtil.add(rootElement, "type", javaClass.getFullyQualifiedName());
        this._addClassCommentElement(rootElement, javaClass);
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "author");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "version");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "see");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "since");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "serial");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "deprecated");
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            this._addMethodElement(rootElement, javaMethod);
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            this._addFieldElement(rootElement, javaField);
        }
        return document;
    }

    private Tuple _getJavadocsXmlTuple(String fileName) throws Exception {
        File file = new File(this._inputDirName + fileName);
        String absolutePath = file.getAbsolutePath();
        absolutePath = StringUtil.replace(absolutePath, '\\', '/');
        absolutePath = StringUtil.replace(absolutePath, "/./", "/");
        int pos = absolutePath.indexOf("/portal-impl/src/");
        String srcDirName = null;
        if (pos != -1) {
            srcDirName = absolutePath.substring(0, pos + 17);
        }
        if (srcDirName == null) {
            pos = absolutePath.indexOf("/portal-kernel/src/");
            if (pos == -1) {
                pos = absolutePath.indexOf("/portal-kernel/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-bridges/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-java/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-taglib/src/");
            }
            if (pos != -1) {
                srcDirName = absolutePath.substring(0, pos) + "/portal-impl/src/";
            }
        }
        if (srcDirName == null && (pos = absolutePath.indexOf("/WEB-INF/src/")) != -1) {
            srcDirName = absolutePath.substring(0, pos + 13);
        }
        if (srcDirName == null && (pos = absolutePath.indexOf("/src/main/java/")) != -1) {
            srcDirName = absolutePath.substring(0, pos) + "/src/main/resources";
        }
        if (srcDirName == null) {
            return null;
        }
        Tuple tuple = this._javadocxXmlTuples.get(srcDirName);
        if (tuple != null) {
            return tuple;
        }
        File metaInfDir = new File(srcDirName, "META-INF");
        if (!metaInfDir.exists()) {
            metaInfDir.mkdirs();
        }
        File javadocsXmlFile = new File(metaInfDir, this._outputFilePrefix + "-all.xml");
        String javadocsXmlContent = null;
        if (!javadocsXmlFile.exists()) {
            javadocsXmlContent = "<?xml version=\"1.0\"?>\n\n<javadocs>\n</javadocs>";
            this._write(javadocsXmlFile, javadocsXmlContent);
            this._modifiedFileNames.add(javadocsXmlFile.getAbsolutePath());
        }
        javadocsXmlContent = this._read(javadocsXmlFile);
        SAXReader saxReader = this._getSAXReader();
        Document javadocsXmlDocument = saxReader.read((Reader)new XMLSafeReader(javadocsXmlContent));
        tuple = new Tuple(srcDirName, javadocsXmlFile, javadocsXmlContent, javadocsXmlDocument);
        this._javadocxXmlTuples.put(srcDirName, tuple);
        return tuple;
    }

    private String _getJavaFieldComment(Map<String, Element> fieldElementsMap, JavaField javaField, String indent) throws Exception {
        String docletTags;
        String fieldKey = this._getFieldKey(javaField);
        Element fieldElement = fieldElementsMap.get(fieldKey);
        if (fieldElement == null) {
            return null;
        }
        StringBundler sb = new StringBundler();
        sb.append(indent);
        sb.append("/**\n");
        String comment = fieldElement.elementText("comment");
        if (Validator.isNotNull(comment)) {
            comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath);
            sb.append(this._wrapText(comment, indent + " * "));
        }
        if (Validator.isNotNull(docletTags = this._addDocletTags(fieldElement, new String[]{"version", "see", "since", "deprecated"}, indent + " * ", this._hasPublicModifier((AbstractJavaEntity)javaField)))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull(comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        if (!this._hasPublicModifier((AbstractJavaEntity)javaField) && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getJavaMethodComment(Map<String, Element> methodElementsMap, JavaMethod javaMethod, String indent) throws Exception {
        String docletTags;
        String methodKey = this._getMethodKey(javaMethod);
        Element methodElement = methodElementsMap.get(methodKey);
        if (methodElement == null) {
            return null;
        }
        StringBundler sb = new StringBundler();
        sb.append(indent);
        sb.append("/**\n");
        String comment = methodElement.elementText("comment");
        if (Validator.isNotNull(comment)) {
            comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath);
            sb.append(this._wrapText(comment, indent + " * "));
        }
        if (Validator.isNotNull(docletTags = this._addDocletTags(methodElement, new String[]{"version", "param", "return", "throws", "see", "since", "deprecated"}, indent + " * ", this._hasPublicModifier((AbstractJavaEntity)javaMethod)))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull(comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        if (!this._hasPublicModifier((AbstractJavaEntity)javaMethod) && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getMethodKey(Element methodElement) {
        StringBundler sb = new StringBundler();
        sb.append(methodElement.elementText("name"));
        sb.append("(");
        List paramElements = methodElement.elements("param");
        for (Element paramElement : paramElements) {
            sb.append(paramElement.elementText("name"));
            sb.append("|");
            sb.append(paramElement.elementText("type"));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getMethodKey(JavaMethod javaMethod) {
        JavaParameter[] javaParameters;
        StringBundler sb = new StringBundler();
        sb.append(javaMethod.getName());
        sb.append("(");
        for (JavaParameter javaParameter : javaParameters = javaMethod.getParameters()) {
            sb.append(javaParameter.getName());
            sb.append("|");
            sb.append(this._getTypeValue(javaParameter));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private SAXReader _getSAXReader() {
        return SAXReaderFactory.getSAXReader(null, false, false);
    }

    private String _getSpacesIndent(int length) {
        String indent = "";
        for (int i = 0; i < length; ++i) {
            indent = indent + " ";
        }
        return indent;
    }

    private String _getTypeValue(JavaParameter javaParameter) {
        Type type = javaParameter.getType();
        String typeValue = type.getValue();
        if (type.isArray()) {
            typeValue = typeValue + "[]";
        }
        return typeValue;
    }

    private String _getUpdateJavaFromDocument(String fileName, String javadocLessContent, Document document) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        String[] lines = StringUtil.splitLines(javadocLessContent);
        JavaClass javaClass = this._getJavaClass(fileName, new UnsyncStringReader(javadocLessContent));
        this._updateLanguageProperties(document, javaClass.getName());
        Element rootElement = document.getRootElement();
        TreeMap<Integer, String> commentsMap = new TreeMap<Integer, String>();
        String javaClassComment = this._getJavaClassComment(rootElement, javaClass);
        javaClassComment = this._addDeprecatedTag(javaClassComment, (AbstractBaseJavaEntity)javaClass, "");
        commentsMap.put(this._getJavaClassLineNumber(javaClass), javaClassComment);
        HashMap<String, Element> methodElementsMap = new HashMap<String, Element>();
        List methodElements = rootElement.elements("method");
        for (JavaMethod[] methodElement : methodElements) {
            String methodKey = this._getMethodKey((Element)methodElement);
            methodElementsMap.put(methodKey, (Element)methodElement);
        }
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            if (commentsMap.containsKey(javaMethod.getLineNumber())) continue;
            String indent = this._getIndent(lines, (AbstractBaseJavaEntity)javaMethod);
            String javaMethodComment = this._getJavaMethodComment(methodElementsMap, javaMethod, indent);
            javaMethodComment = this._addDeprecatedTag(javaMethodComment, (AbstractBaseJavaEntity)javaMethod, indent);
            commentsMap.put(javaMethod.getLineNumber(), javaMethodComment);
        }
        HashMap<String, Element> fieldElementsMap = new HashMap<String, Element>();
        List fieldElements = rootElement.elements("field");
        for (JavaField[] fieldElement : fieldElements) {
            String fieldKey = this._getFieldKey((Element)fieldElement);
            fieldElementsMap.put(fieldKey, (Element)fieldElement);
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            if (commentsMap.containsKey(javaField.getLineNumber())) continue;
            String indent = this._getIndent(lines, (AbstractBaseJavaEntity)javaField);
            String javaFieldComment = this._getJavaFieldComment(fieldElementsMap, javaField, indent);
            javaFieldComment = this._addDeprecatedTag(javaFieldComment, (AbstractBaseJavaEntity)javaField, indent);
            commentsMap.put(javaField.getLineNumber(), javaFieldComment);
        }
        StringBundler sb = new StringBundler(javadocLessContent.length());
        for (int lineNumber = 1; lineNumber <= lines.length; ++lineNumber) {
            String line = lines[lineNumber - 1];
            String comments = (String)commentsMap.get(lineNumber);
            if (comments != null) {
                sb.append(comments);
            }
            sb.append(line);
            sb.append("\n");
        }
        String formattedContent = sb.toString();
        return formattedContent.trim();
    }

    private boolean _hasAnnotation(AbstractBaseJavaEntity abstractBaseJavaEntity, String annotationName) {
        Annotation[] annotations = abstractBaseJavaEntity.getAnnotations();
        if (annotations == null) {
            return false;
        }
        for (int i = 0; i < annotations.length; ++i) {
            Type type = annotations[i].getType();
            JavaClass javaClass = type.getJavaClass();
            if (!annotationName.equals(javaClass.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean _hasGeneratedTag(String content) {
        return (content.contains("* @generated") || content.contains("$ANTLR") || content.contains("auto-generated from WSDL")) && !content.contains("hasGeneratedTag");
    }

    private boolean _hasPublicModifier(AbstractJavaEntity abstractJavaEntity) {
        String[] modifiers = abstractJavaEntity.getModifiers();
        if (modifiers == null) {
            return false;
        }
        for (String modifier : modifiers) {
            if (!modifier.equals("public")) continue;
            return true;
        }
        return false;
    }

    private void _populateJavadocBuilder(String[] fileNames) {
        this._javadocBuilder = new JavaDocBuilder();
        for (String fileName : fileNames) {
            fileName = StringUtil.replace(fileName, '\\', '/');
            File file = new File(this._inputDirName, fileName);
            try {
                this._javadocBuilder.addSource(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String _read(File file) throws IOException {
        String s = new String(Files.readAllBytes(file.toPath()), "UTF-8");
        return StringUtil.replace(s, "\r\n", "\n");
    }

    private String _removeJavadocFromJava(JavaClass javaClass, String content) {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        lineNumbers.add(this._getJavaClassLineNumber(javaClass));
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            lineNumbers.add(javaMethod.getLineNumber());
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            lineNumbers.add(javaField.getLineNumber());
        }
        String[] lines = StringUtil.splitLines(content);
        Iterator iterator = lineNumbers.iterator();
        while (iterator.hasNext()) {
            int pos;
            String line;
            int lineNumber = (Integer)iterator.next();
            if (lineNumber == 0 || (line = lines[pos = lineNumber - 2]) == null) continue;
            int blankLines = 0;
            while (line.equals("")) {
                line = lines[--pos];
                ++blankLines;
            }
            if (!(line = line.trim()).endsWith("*/")) continue;
            while (true) {
                lines[pos] = null;
                if (line.startsWith("/**") || line.startsWith("/*")) break;
                line = lines[--pos].trim();
            }
            for (int i = 0; i < blankLines; ++i) {
                lines[lineNumber - i - 2] = null;
            }
        }
        StringBundler sb = new StringBundler(content.length());
        for (String line : lines) {
            if (line == null) continue;
            sb.append(line);
            sb.append("\n");
        }
        content = sb.toString();
        return content.trim();
    }

    /*
     * WARNING - void declaration
     */
    private void _sortElementsByChildElement(Element element, String elementName, String childElementName) {
        void var7_14;
        Element curElement;
        Element element2;
        TreeMap<String, Element> elementsMap = new TreeMap<String, Element>();
        List elements = element.elements();
        for (Element element3 : elements) {
            element3.detach();
            if (!elementName.equals(element3.getName())) continue;
            String childElementValue = element3.elementText(childElementName);
            elementsMap.put(childElementValue, element3);
        }
        Iterator<Object> iterator = elements.iterator();
        while (iterator.hasNext() && !elementName.equals((element2 = (Element)iterator.next()).getName())) {
            element.add(element2);
        }
        for (Map.Entry entry : elementsMap.entrySet()) {
            curElement = (Element)entry.getValue();
            element.add(curElement);
        }
        boolean foundLastElementWithElementName = false;
        boolean bl = false;
        while (var7_14 < elements.size()) {
            curElement = (Element)elements.get((int)var7_14);
            if (!foundLastElementWithElementName) {
                Element nextElement;
                if (elementName.equals(curElement.getName()) && var7_14 + true < elements.size() && !elementName.equals((nextElement = (Element)elements.get((int)(var7_14 + true))).getName())) {
                    foundLastElementWithElementName = true;
                }
            } else {
                element.add(curElement);
            }
            ++var7_14;
        }
    }

    private String _trimMultilineText(String text) {
        String[] lines = StringUtil.splitLines(text);
        StringBundler sb = new StringBundler();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            sb.append(line);
            if (line.endsWith("(") || i >= lines.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private void _updateJavadocsXmlFile(String fileName, JavaClass javaClass, Document javaClassDocument) throws Exception {
        String javaClassFullyQualifiedName = javaClass.getFullyQualifiedName();
        Tuple javadocsXmlTuple = this._getJavadocsXmlTuple(fileName);
        if (javadocsXmlTuple == null) {
            return;
        }
        Document javadocsXmlDocument = (Document)javadocsXmlTuple.getObject(3);
        Element javadocsXmlRootElement = javadocsXmlDocument.getRootElement();
        List javadocElements = javadocsXmlRootElement.elements("javadoc");
        for (Element javadocElement : javadocElements) {
            String type = javadocElement.elementText("type");
            if (!type.equals(javaClassFullyQualifiedName)) continue;
            Element javaClassRootElement = javaClassDocument.getRootElement();
            if (Objects.equals(this._formattedString((Node)javadocElement), this._formattedString((Node)javaClassRootElement))) {
                return;
            }
            javadocElement.detach();
            break;
        }
        javadocsXmlRootElement.add(javaClassDocument.getRootElement());
    }

    private void _updateLanguageProperties(Document document, String className) throws IOException {
        if (this._languageProperties == null) {
            return;
        }
        int index = className.indexOf("ServiceImpl");
        if (index <= 0) {
            return;
        }
        StringBundler sb = new StringBundler();
        sb.append(Character.toLowerCase(className.charAt(0)));
        for (int i = 1; i < index; ++i) {
            char c = className.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i + 1 < index && Character.isLowerCase(className.charAt(i + 1))) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        sb.append("-service-help");
        String key = sb.toString();
        String value = this._languageProperties.getProperty(key);
        if (value == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        String comment = rootElement.elementText("comment");
        if (comment == null || value.equals(comment)) {
            return;
        }
        index = comment.indexOf("\n\n");
        value = index != -1 ? comment.substring(0, index) : comment;
        this._updateLanguageProperties(key, value);
    }

    private void _updateLanguageProperties(String key, String value) throws IOException {
        StringBundler sb = new StringBundler();
        try (BufferedReader bufferedReader = Files.newBufferedReader(this._languagePropertiesFile.toPath(), StandardCharsets.UTF_8);){
            boolean begin = false;
            boolean firstLine = true;
            String linePrefix = key + "=";
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.equals("")) {
                    boolean bl = begin = !begin;
                }
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append("\n");
                }
                if (line.startsWith(linePrefix)) {
                    sb.append(linePrefix);
                    sb.append(value);
                    continue;
                }
                sb.append(line);
            }
        }
        var5_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this._languagePropertiesFile, false), StandardCharsets.UTF_8);){
            sb.writeTo(writer);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        System.out.println("Updating " + this._languagePropertiesFile + " key " + key);
    }

    private String _wrapText(String text, int indentLength, String exclude) {
        StringBuffer sb = new StringBuffer();
        StringBundler regexSB = new StringBundler("(?<=^|</");
        regexSB.append(exclude);
        regexSB.append(">).+?(?=$|<");
        regexSB.append(exclude);
        regexSB.append(">)");
        Pattern pattern = Pattern.compile(regexSB.toString(), 32);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String wrapped = this._formatInlines(matcher.group());
            wrapped = StringUtil.wrap(wrapped, 80 - indentLength, "\n");
            matcher.appendReplacement(sb, wrapped);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String _wrapText(String text, String indent) {
        int indentLength = this._getIndentLength(indent);
        if (text.contains("<pre>")) {
            text = this._wrapText(text, indentLength, "pre");
        } else if (text.contains("<table>")) {
            text = this._wrapText(text, indentLength, "table");
        } else {
            text = this._formatInlines(text);
            text = StringUtil.wrap(text, 80 - indentLength, "\n");
        }
        text = text.replaceAll("(?m)^", indent);
        text = text.replaceAll("(?m) +$", "");
        return text;
    }

    private void _write(File file, String s) throws IOException {
        Files.write(file.toPath(), s.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

