/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ratings.kernel.definition;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.ratings.kernel.RatingsType;
import com.liferay.ratings.kernel.definition.PortletRatingsDefinition;
import com.liferay.ratings.kernel.definition.PortletRatingsDefinitionValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PortletRatingsDefinitionUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortletRatingsDefinitionUtil.class);
    private static final ServiceTrackerCustomizer<PortletRatingsDefinition, PortletRatingsDefinitionValues> _serviceTrackerCustomizer = new ServiceTrackerCustomizer<PortletRatingsDefinition, PortletRatingsDefinitionValues>(){

        public PortletRatingsDefinitionValues addingService(ServiceReference<PortletRatingsDefinition> serviceReference) {
            Object[] classNames = null;
            Object modelClassName = serviceReference.getProperty("model.class.name");
            classNames = modelClassName instanceof Object[] ? (String[])modelClassName : new String[]{(String)modelClassName};
            if (ArrayUtil.isEmpty(classNames)) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Property \"model.class.name\" is not set");
                }
                return null;
            }
            Registry registry = RegistryUtil.getRegistry();
            PortletRatingsDefinition portletRatingsDefinition = (PortletRatingsDefinition)registry.getService(serviceReference);
            RatingsType defaultRatingsType = portletRatingsDefinition.getDefaultRatingsType();
            if (defaultRatingsType == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Default ratings type is null");
                }
                return null;
            }
            String portletId = portletRatingsDefinition.getPortletId();
            if (Validator.isNull(portletId)) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Portlet ID is null");
                }
                return null;
            }
            return new PortletRatingsDefinitionValues((String[])classNames, defaultRatingsType, portletId);
        }

        public void modifiedService(ServiceReference<PortletRatingsDefinition> serviceReference, PortletRatingsDefinitionValues portletRatingsDefinitionValues) {
        }

        public void removedService(ServiceReference<PortletRatingsDefinition> serviceReference, PortletRatingsDefinitionValues portletRatingsDefinitionValues) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }
    };
    private static final ServiceTrackerMap<String, PortletRatingsDefinitionValues> _serviceTrackerMap = ServiceTrackerCollections.openSingleValueMap(PortletRatingsDefinition.class, (String)"model.class.name", _serviceTrackerCustomizer);

    public static RatingsType getDefaultRatingsType(String className) {
        PortletRatingsDefinitionValues portletRatingsDefinitionValues = (PortletRatingsDefinitionValues)_serviceTrackerMap.getService((Object)className);
        if (portletRatingsDefinitionValues == null) {
            return null;
        }
        return portletRatingsDefinitionValues.getDefaultRatingsType();
    }

    public static Map<String, PortletRatingsDefinitionValues> getPortletRatingsDefinitionValuesMap() {
        HashMap<String, Object> portletRatingsDefinitionValuesMap = new HashMap<String, Object>();
        for (String className : _serviceTrackerMap.keySet()) {
            portletRatingsDefinitionValuesMap.put(className, _serviceTrackerMap.getService((Object)className));
        }
        return Collections.unmodifiableMap(portletRatingsDefinitionValuesMap);
    }
}

