/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.fileserver;

import com.liferay.portal.kernel.io.PathHolder;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.nio.file.Path;

public class FileRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean _deleteAfterFetch;
    private final long _lastModifiedTime;
    private final PathHolder _pathHolder;

    public FileRequest(Path path, long lastModifiedTime, boolean deleteAfterFetch) {
        this._lastModifiedTime = lastModifiedTime;
        this._deleteAfterFetch = deleteAfterFetch;
        this._pathHolder = new PathHolder(path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileRequest)) {
            return false;
        }
        FileRequest fileRequest = (FileRequest)obj;
        return this._deleteAfterFetch == fileRequest._deleteAfterFetch && this._lastModifiedTime == fileRequest._lastModifiedTime && this._pathHolder.equals((Object)fileRequest._pathHolder);
    }

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public Path getPath() {
        return this._pathHolder.getPath();
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (boolean)this._deleteAfterFetch);
        hash = HashUtil.hash((int)hash, (long)this._lastModifiedTime);
        hash = HashUtil.hash((int)hash, (Object)this._pathHolder);
        return hash;
    }

    public boolean isDeleteAfterFetch() {
        return this._deleteAfterFetch;
    }

    public String toString() {
        StringBundler sb = new StringBundler(7);
        sb.append("{deleteAfterFetch=");
        sb.append(this._deleteAfterFetch);
        sb.append(", lastModifiedTime=");
        sb.append(this._lastModifiedTime);
        sb.append(", pathHolder=");
        sb.append((Object)this._pathHolder);
        sb.append("}");
        return sb.toString();
    }
}

