/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceTypePermissionLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.HashSet;
import java.util.Set;

@DoPrivileged
public class InlineSQLHelperImpl
implements InlineSQLHelper {
    public static final String FILTER_BY_RESOURCE_BLOCK_ID = InlineSQLHelper.class.getName() + ".filterByResourceBlockId";
    public static final String FILTER_BY_RESOURCE_BLOCK_ID_OWNER = InlineSQLHelper.class.getName() + ".filterByResourceBlockIdOwner";
    public static final String FIND_BY_RESOURCE_BLOCK_ID = InlineSQLHelper.class.getName() + ".findByResourceBlockId";
    public static final String JOIN_RESOURCE_PERMISSION = InlineSQLHelper.class.getName() + ".joinResourcePermission";
    private static final String _GROUP_BY_CLAUSE = " GROUP BY ";
    private static final long _NO_RESOURCE_BLOCKS_ID = -1L;
    private static final long[] _NO_ROLE_IDS = new long[]{0L};
    private static final String _ORDER_BY_CLAUSE = " ORDER BY ";
    private static final String _WHERE_CLAUSE = " WHERE ";
    private static final Log _log = LogFactoryUtil.getLog(InlineSQLHelperImpl.class);

    public boolean isEnabled() {
        return this.isEnabled(0L, 0L);
    }

    public boolean isEnabled(long groupId) {
        return this.isEnabled(0L, groupId);
    }

    public boolean isEnabled(long companyId, long groupId) {
        if (!PropsValues.PERMISSIONS_INLINE_SQL_CHECK_ENABLED) {
            return false;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            throw new IllegalStateException("Permission checker is null");
        }
        return !(groupId > 0L ? permissionChecker.isGroupAdmin(groupId) || permissionChecker.isGroupOwner(groupId) : (companyId > 0L ? permissionChecker.isCompanyAdmin(companyId) : permissionChecker.isOmniadmin()));
    }

    public boolean isEnabled(long[] groupIds) {
        if (!PropsValues.PERMISSIONS_INLINE_SQL_CHECK_ENABLED) {
            return false;
        }
        for (long groupId : groupIds) {
            if (!this.isEnabled(groupId)) continue;
            return true;
        }
        return false;
    }

    public String replacePermissionCheck(String sql, String className, String classPKField) {
        return this.replacePermissionCheck(sql, className, classPKField, null, new long[]{0L}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long groupId) {
        return this.replacePermissionCheck(sql, className, classPKField, null, new long[]{groupId}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long groupId, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, null, new long[]{groupId}, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long[] groupIds) {
        return this.replacePermissionCheck(sql, className, classPKField, null, groupIds, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long[] groupIds, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, null, groupIds, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{0L}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long groupId) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{groupId}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long groupId, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{groupId}, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long[] groupIds) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, groupIds, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long[] groupIds, String bridgeJoin) {
        String groupIdField = classPKField.substring(0, classPKField.lastIndexOf(46));
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, groupIdField.concat(".groupId"), groupIds, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, 0L, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, String groupIdField, long[] groupIds, String bridgeJoin) {
        if (!this.isEnabled(groupIds)) {
            return sql;
        }
        if (Validator.isNull((String)className)) {
            throw new IllegalArgumentException("className is null");
        }
        if (Validator.isNull((String)sql)) {
            return sql;
        }
        if (ResourceBlockLocalServiceUtil.isSupported((String)className)) {
            return this.replacePermissionCheckBlocks(sql, className, classPKField, userIdField, groupIds, bridgeJoin);
        }
        return this.replacePermissionCheckJoin(sql, className, classPKField, userIdField, groupIdField, groupIds, bridgeJoin);
    }

    protected Set<Long> getOwnerResourceBlockIds(long companyId, long[] groupIds, String className) {
        HashSet<Long> resourceBlockIds = new HashSet<Long>();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        for (long groupId : groupIds) {
            resourceBlockIds.addAll(permissionChecker.getOwnerResourceBlockIds(companyId, groupId, className, "VIEW"));
        }
        return resourceBlockIds;
    }

    protected String getOwnerResourceBlockIdsSQL(PermissionChecker permissionChecker, long checkGroupId, String className, Set<Long> ownerResourceBlockIds) {
        if (ownerResourceBlockIds.size() < PropsValues.PERMISSIONS_INLINE_SQL_RESOURCE_BLOCK_QUERY_THRESHOLD) {
            return StringUtil.merge(ownerResourceBlockIds);
        }
        return StringUtil.replace((String)CustomSQLUtil.get((String)FIND_BY_RESOURCE_BLOCK_ID), (String[])new String[]{"[$COMPANY_ID$]", "[$GROUP_ID$]", "[$RESOURCE_BLOCK_NAME$]", "[$ROLE_ID$]"}, (String[])new String[]{String.valueOf(permissionChecker.getCompanyId()), String.valueOf(checkGroupId), className, StringUtil.valueOf((Object)permissionChecker.getOwnerRoleId())});
    }

    protected Set<Long> getResourceBlockIds(long companyId, long[] groupIds, String className) {
        HashSet<Long> resourceBlockIds = new HashSet<Long>();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        for (long groupId : groupIds) {
            resourceBlockIds.addAll(permissionChecker.getResourceBlockIds(companyId, groupId, permissionChecker.getUserId(), className, "VIEW"));
        }
        return resourceBlockIds;
    }

    protected long[] getRoleIds(long groupId) {
        long[] roleIds = PermissionChecker.DEFAULT_ROLE_IDS;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            roleIds = permissionChecker.getRoleIds(permissionChecker.getUserId(), groupId);
        }
        return roleIds;
    }

    protected long[] getRoleIds(long[] groupIds) {
        HashSet<Long> roleIds = new HashSet<Long>();
        for (long groupId : groupIds) {
            for (long roleId : this.getRoleIds(groupId)) {
                roleIds.add(roleId);
            }
        }
        return ArrayUtil.toLongArray(roleIds);
    }

    protected String getRoleIdsOrOwnerIdSQL(PermissionChecker permissionChecker, long[] groupIds, String userIdField) {
        StringBundler sb = new StringBundler();
        sb.append("(");
        sb.append("ResourcePermission.roleId IN (");
        long[] roleIds = this.getRoleIds(groupIds);
        if (roleIds.length == 0) {
            roleIds = _NO_ROLE_IDS;
        }
        sb.append(StringUtil.merge((long[])roleIds));
        sb.append(")");
        if (permissionChecker.isSignedIn()) {
            sb.append(" OR ");
            long userId = permissionChecker.getUserId();
            if (Validator.isNotNull((String)userIdField)) {
                sb.append("(");
                sb.append(userIdField);
                sb.append(" = ");
                sb.append(userId);
                sb.append(")");
            } else {
                sb.append("(ResourcePermission.ownerId = ");
                sb.append(userId);
                sb.append(")");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected long getUserId() {
        long userId = 0L;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            userId = permissionChecker.getUserId();
        }
        return userId;
    }

    protected String getUserResourceBlockIdsSQL(PermissionChecker permissionChecker, long checkGroupId, long[] roleIds, String className, Set<Long> userResourceBlockIds) {
        if (userResourceBlockIds.size() < PropsValues.PERMISSIONS_INLINE_SQL_RESOURCE_BLOCK_QUERY_THRESHOLD) {
            return StringUtil.merge(userResourceBlockIds);
        }
        return StringUtil.replace((String)CustomSQLUtil.get((String)FIND_BY_RESOURCE_BLOCK_ID), (String[])new String[]{"[$COMPANY_ID$]", "[$GROUP_ID$]", "[$RESOURCE_BLOCK_NAME$]", "[$ROLE_ID$]"}, (String[])new String[]{String.valueOf(permissionChecker.getCompanyId()), String.valueOf(checkGroupId), className, StringUtil.merge((long[])roleIds)});
    }

    protected String replacePermissionCheckBlocks(String sql, String className, String classPKField, String userIdField, long[] groupIds, String bridgeJoin) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long checkGroupId = 0L;
        if (groupIds.length == 1) {
            checkGroupId = groupIds[0];
        }
        long[] roleIds = permissionChecker.getRoleIds(this.getUserId(), checkGroupId);
        try {
            for (long roleId : roleIds) {
                if (!ResourceTypePermissionLocalServiceUtil.hasCompanyScopePermission((long)permissionChecker.getCompanyId(), (String)className, (long)roleId, (String)"VIEW")) continue;
                return sql;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Set<Long> userResourceBlockIds = this.getResourceBlockIds(permissionChecker.getCompanyId(), groupIds, className);
        String permissionWhere = "";
        if (Validator.isNotNull((String)bridgeJoin)) {
            permissionWhere = bridgeJoin;
        }
        Set<Long> ownerResourceBlockIds = this.getOwnerResourceBlockIds(permissionChecker.getCompanyId(), groupIds, className);
        ownerResourceBlockIds.removeAll(userResourceBlockIds);
        if (ownerResourceBlockIds.isEmpty()) {
            ownerResourceBlockIds.add(-1L);
        }
        if (userResourceBlockIds.isEmpty()) {
            userResourceBlockIds.add(-1L);
        }
        if (Validator.isNotNull((String)userIdField)) {
            permissionWhere = permissionWhere.concat(CustomSQLUtil.get((String)FILTER_BY_RESOURCE_BLOCK_ID_OWNER));
            permissionWhere = StringUtil.replace((String)permissionWhere, (String[])new String[]{"[$OWNER_RESOURCE_BLOCK_ID$]", "[$USER_ID$]", "[$USER_ID_FIELD$]", "[$USER_RESOURCE_BLOCK_ID$]"}, (String[])new String[]{this.getOwnerResourceBlockIdsSQL(permissionChecker, checkGroupId, className, ownerResourceBlockIds), String.valueOf(permissionChecker.getUserId()), userIdField, this.getUserResourceBlockIdsSQL(permissionChecker, checkGroupId, roleIds, className, userResourceBlockIds)});
        } else {
            permissionWhere = permissionWhere.concat(CustomSQLUtil.get((String)FILTER_BY_RESOURCE_BLOCK_ID));
            permissionWhere = StringUtil.replace((String)permissionWhere, (String)"[$USER_RESOURCE_BLOCK_ID$]", (String)this.getUserResourceBlockIdsSQL(permissionChecker, checkGroupId, roleIds, className, userResourceBlockIds));
        }
        int pos = sql.indexOf(_WHERE_CLAUSE);
        if (pos != -1) {
            StringBundler sb = new StringBundler(4);
            sb.append(sql.substring(0, pos));
            sb.append(permissionWhere);
            sb.append(" AND ");
            sb.append(sql.substring(pos + 7));
            return sb.toString();
        }
        pos = sql.indexOf(_GROUP_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionWhere).concat(sql.substring(pos + 1));
        }
        pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionWhere).concat(sql.substring(pos + 1));
        }
        return sql.concat(" ").concat(permissionWhere);
    }

    protected String replacePermissionCheckJoin(String sql, String className, String classPKField, String userIdField, String groupIdField, long[] groupIds, String bridgeJoin) {
        long companyId;
        PermissionChecker permissionChecker;
        block23: {
            if (Validator.isNull((String)classPKField)) {
                throw new IllegalArgumentException("classPKField is null");
            }
            permissionChecker = PermissionThreadLocal.getPermissionChecker();
            companyId = 0L;
            if (groupIds.length == 1) {
                long groupId = groupIds[0];
                Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
                if (group != null) {
                    companyId = group.getCompanyId();
                    long[] roleIds = this.getRoleIds(groupId);
                    try {
                        if (ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)2, (String)String.valueOf(groupId), (long[])roleIds, (String)"VIEW")) {
                            return sql;
                        }
                        if (ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)3, (String)String.valueOf(0L), (long[])roleIds, (String)"VIEW")) {
                            return sql;
                        }
                    }
                    catch (PortalException pe) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Unable to get resource permissions for " + className + " with group " + groupId), (Throwable)pe);
                        }
                    }
                }
            } else {
                for (long groupId : groupIds) {
                    Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
                    if (group == null) continue;
                    if (companyId == 0L) {
                        companyId = group.getCompanyId();
                        continue;
                    }
                    if (group.getCompanyId() == companyId) continue;
                    throw new IllegalArgumentException("Permission queries across multiple portal instances are not supported");
                }
            }
            if (companyId == 0L) {
                companyId = permissionChecker.getCompanyId();
            }
            try {
                if (ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)1, (String)String.valueOf(companyId), (long[])this.getRoleIds(0L), (String)"VIEW")) {
                    return sql;
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block23;
                _log.debug((Object)("Unable to get resource permissions for " + className + " with company " + companyId), (Throwable)pe);
            }
        }
        String permissionJoin = "";
        if (Validator.isNotNull((String)bridgeJoin)) {
            permissionJoin = bridgeJoin;
        }
        permissionJoin = permissionJoin + CustomSQLUtil.get((String)JOIN_RESOURCE_PERMISSION);
        StringBundler sb = new StringBundler(8);
        sb.append("((ResourcePermission.primKeyId = ");
        sb.append(classPKField);
        if (Validator.isNotNull((String)groupIdField) && groupIds.length > 0) {
            sb.append(") AND (");
            sb.append(groupIdField);
            if (groupIds.length > 1) {
                sb.append(" IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
            } else {
                sb.append(" = ");
                sb.append(groupIds[0]);
            }
        }
        sb.append("))");
        String roleIdsOrOwnerIdSQL = this.getRoleIdsOrOwnerIdSQL(permissionChecker, groupIds, userIdField);
        int scope = 4;
        permissionJoin = StringUtil.replace((String)permissionJoin, (String[])new String[]{"[$CLASS_NAME$]", "[$COMPANY_ID$]", "[$PRIM_KEYS$]", "[$RESOURCE_SCOPE_INDIVIDUAL$]", "[$ROLE_IDS_OR_OWNER_ID$]"}, (String[])new String[]{className, String.valueOf(companyId), sb.toString(), String.valueOf(scope), roleIdsOrOwnerIdSQL});
        int pos = sql.indexOf(_WHERE_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionJoin).concat(sql.substring(pos + 1));
        }
        pos = sql.indexOf(_GROUP_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionJoin).concat(sql.substring(pos + 1));
        }
        pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionJoin).concat(sql.substring(pos + 1));
        }
        return sql.concat(" ").concat(permissionJoin);
    }
}

