/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Project;

public abstract class BaseFailureMessageGenerator
implements FailureMessageGenerator {
    private static final Pattern _pattern = Pattern.compile("\\n[a-z\\-\\.]+\\:\\n");

    @Override
    public abstract String getMessage(String var1, String var2, Project var3) throws Exception;

    protected String getConsoleOutputSnippet(String consoleOutput, int end) {
        int start;
        if (end == -1) {
            end = consoleOutput.length();
        }
        if (end - (start = this.getSnippetStart(consoleOutput, end)) > 2500) {
            start = end - 2500;
            start = consoleOutput.indexOf("\n", start);
        }
        consoleOutput = JenkinsResultsParserUtil.fixMarkdown(consoleOutput.substring(start, end));
        return "<pre>" + consoleOutput + "</pre>";
    }

    protected int getSnippetStart(String consoleOutput, int end) {
        int start = 0;
        Matcher matcher = _pattern.matcher(consoleOutput);
        while (matcher.find()) {
            int x = matcher.start() + 1;
            if (x >= end) {
                return start;
            }
            start = x;
        }
        return start;
    }
}

