/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import org.apache.tools.ant.Project;

public class GenericFailureMessageGenerator
extends BaseFailureMessageGenerator {
    @Override
    public String getMessage(String buildURL, String consoleOutput, Project project) throws Exception {
        String message = this.getExceptionSnippet(consoleOutput);
        if (message != null) {
            return message;
        }
        message = this.getMergeTestResultsSnippet(consoleOutput);
        if (message != null) {
            return message;
        }
        message = this.getBuildFailedSnippet(consoleOutput);
        if (message != null) {
            return message;
        }
        return this.getConsoleOutputSnippet(consoleOutput, -1);
    }

    protected String getBuildFailedSnippet(String consoleOutput) {
        int end = consoleOutput.indexOf("BUILD FAILED");
        if (end == -1) {
            return null;
        }
        end = consoleOutput.indexOf("Total time:", end);
        return this.getConsoleOutputSnippet(consoleOutput, end);
    }

    protected String getExceptionSnippet(String consoleOutput) {
        int end = consoleOutput.indexOf("[exec] * Exception is:");
        if (end == -1) {
            return null;
        }
        end = consoleOutput.indexOf("\n", end + 500);
        return this.getConsoleOutputSnippet(consoleOutput, end);
    }

    protected String getMergeTestResultsSnippet(String consoleOutput) {
        int end = consoleOutput.indexOf("merge-test-results:");
        if (end == -1) {
            return null;
        }
        return this.getConsoleOutputSnippet(consoleOutput, end);
    }
}

