/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsResultsParserUtil {
    protected static final String DEPENDENCIES_URL = "http://mirrors-no-cache.lax.liferay.com/github.com/liferay/liferay-jenkins-results-parser-samples-ee/1/";
    private static final Pattern _localURLPattern1 = Pattern.compile("https://test.liferay.com/([0-9]+)/");
    private static final Pattern _localURLPattern2 = Pattern.compile("https://(test-[0-9]+-[0-9]+).liferay.com/");
    private static final Map<String, String> _toStringCache = new HashMap<String, String>();

    public static JSONObject createJSONObject(String jsonString) throws Exception {
        JSONObject jsonObject = new JSONObject(jsonString);
        if (jsonObject.isNull("duration") || jsonObject.isNull("result") || jsonObject.isNull("url")) {
            return jsonObject;
        }
        String url = jsonObject.getString("url");
        if (!url.contains("AXIS_VARIABLE")) {
            return jsonObject;
        }
        Object result = jsonObject.get("result");
        if (result instanceof JSONObject) {
            return jsonObject;
        }
        if (jsonObject.getInt("duration") == 0 && result.equals("FAILURE")) {
            String actualResult = JenkinsResultsParserUtil.getActualResult(url);
            System.out.println("Actual Result: " + actualResult);
            jsonObject.putOpt("result", (Object)actualResult);
        }
        return jsonObject;
    }

    public static URL createURL(String urlString) throws Exception {
        URL url = new URL(urlString);
        return JenkinsResultsParserUtil.encode(url);
    }

    public static URL encode(URL url) throws Exception {
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        String uriASCIIString = uri.toASCIIString();
        return new URL(uriASCIIString.replace("#", "%23"));
    }

    public static String expandSlaveRange(String value) {
        StringBuilder sb = new StringBuilder();
        for (String hostName : value.split(",")) {
            int x = (hostName = hostName.trim()).indexOf("..");
            if (x == -1) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(hostName);
                continue;
            }
            int y = hostName.lastIndexOf("-") + 1;
            String prefix = hostName.substring(0, y);
            int first = Integer.parseInt(hostName.substring(y, x));
            int last = Integer.parseInt(hostName.substring(x + 2));
            for (int current = first; current <= last; ++current) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(prefix);
                sb.append(current);
            }
        }
        return sb.toString();
    }

    public static String fixFileName(String fileName) {
        String prefix = "";
        if (fileName.startsWith("file:")) {
            prefix = "file:";
            fileName = fileName.substring(prefix.length());
        }
        fileName = fileName.replace(">", "[gt]");
        fileName = fileName.replace("<", "[lt]");
        fileName = fileName.replace("|", "[pi]");
        fileName = fileName.replace("?", "[qt]");
        fileName = fileName.replace(":", "[sc]");
        return prefix + fileName;
    }

    public static String fixJSON(String json) {
        json = json.replaceAll("'", "&#39;");
        json = json.replaceAll("<", "&#60;");
        json = json.replaceAll(">", "&#62;");
        json = json.replaceAll("\\(", "&#40;");
        json = json.replaceAll("\\)", "&#41;");
        json = json.replaceAll("\\[", "&#91;");
        json = json.replaceAll("\\\"", "&#34;");
        json = json.replaceAll("\\\\", "&#92;");
        json = json.replaceAll("\\]", "&#93;");
        json = json.replaceAll("\\{", "&#123;");
        json = json.replaceAll("\\}", "&#125;");
        json = json.replaceAll("\n", "<br />");
        json = json.replaceAll("\t", "&#09;");
        json = json.replaceAll("\u00bb", "&raquo;");
        return json;
    }

    public static String fixMarkdown(String markdown) {
        markdown = markdown.replace("\\", "\\\\");
        markdown = markdown.replace("`", "\\`");
        markdown = markdown.replace("*", "\\*");
        markdown = markdown.replace("_", "\\_");
        markdown = markdown.replace("{", "\\{");
        markdown = markdown.replace("}", "\\}");
        markdown = markdown.replace("[", "\\[");
        markdown = markdown.replace("]", "\\]");
        markdown = markdown.replace("(", "\\(");
        markdown = markdown.replace(")", "\\)");
        markdown = markdown.replace("#", "\\#");
        markdown = markdown.replace("+", "\\+");
        markdown = markdown.replace("-", "\\-");
        markdown = markdown.replace(".", "\\.");
        markdown = markdown.replace("!", "\\!");
        return markdown;
    }

    public static String fixURL(String url) {
        url = url.replace("(", "%28");
        url = url.replace(")", "%29");
        url = url.replace("[", "%5B");
        url = url.replace("]", "%5D");
        return url;
    }

    public static String format(Element element) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
        xmlWriter.write(element);
        return ((Object)writer).toString();
    }

    public static String getActualResult(String buildURL) throws Exception {
        String progressiveText = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(buildURL + "/logText/progressiveText"), false);
        if (progressiveText.contains("Finished:")) {
            if (progressiveText.contains("Finished: SUCCESS")) {
                return "SUCCESS";
            }
            if (progressiveText.contains("Finished: UNSTABLE")) {
                return "FAILURE";
            }
            if (progressiveText.contains("Finished: FAILURE")) {
                return "FAILURE";
            }
        }
        return null;
    }

    public static String getAxisVariable(JSONObject jsonObject) throws Exception {
        JSONArray actionsJSONArray = (JSONArray)jsonObject.get("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionsJSONObject;
            JSONArray parametersJSONArray;
            Object object = actionsJSONArray.get(i);
            if (object.equals(JSONObject.NULL) || (parametersJSONArray = (actionsJSONObject = actionsJSONArray.getJSONObject(i)).optJSONArray("parameters")) == null) continue;
            for (int j = 0; j < parametersJSONArray.length(); ++j) {
                JSONObject parametersJSONObject = parametersJSONArray.getJSONObject(j);
                String name = parametersJSONObject.getString("name");
                if (!name.contains("AXIS_VARIABLE")) continue;
                return parametersJSONObject.getString("value");
            }
        }
        return "";
    }

    public static String getJobVariant(JSONObject jsonObject) throws Exception {
        JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionsJSONObject;
            Object object = actionsJSONArray.get(i);
            if (object.equals(JSONObject.NULL) || !(actionsJSONObject = actionsJSONArray.getJSONObject(i)).has("parameters")) continue;
            JSONArray parametersJSONArray = actionsJSONObject.getJSONArray("parameters");
            for (int j = 0; j < parametersJSONArray.length(); ++j) {
                JSONObject parametersJSONObject = parametersJSONArray.getJSONObject(j);
                if (!"JOB_VARIANT".contains(parametersJSONObject.getString("name"))) continue;
                return parametersJSONObject.getString("value");
            }
        }
        return "";
    }

    public static String getJobVariant(String json) throws Exception {
        return JenkinsResultsParserUtil.getJobVariant(new JSONObject(json));
    }

    public static String getLocalURL(String remoteURL) {
        Matcher matcher;
        if (remoteURL.contains("${dependencies.url}")) {
            remoteURL = JenkinsResultsParserUtil.fixFileName(remoteURL);
            remoteURL = remoteURL.replace("${dependencies.url}", DEPENDENCIES_URL);
        }
        if (remoteURL.startsWith("file")) {
            remoteURL = JenkinsResultsParserUtil.fixFileName(remoteURL);
        }
        if ((matcher = _localURLPattern1.matcher(remoteURL)).find()) {
            StringBuilder sb = new StringBuilder();
            sb.append("http://test-");
            sb.append(matcher.group(1));
            sb.append("/");
            sb.append(matcher.group(1));
            sb.append("/");
            return remoteURL.replaceAll(matcher.group(0), sb.toString());
        }
        matcher = _localURLPattern2.matcher(remoteURL);
        if (matcher.find()) {
            StringBuilder sb = new StringBuilder();
            sb.append("http://");
            sb.append(matcher.group(1));
            sb.append("/");
            return remoteURL.replaceAll(matcher.group(0), sb.toString());
        }
        return remoteURL;
    }

    public static String read(File file) throws IOException {
        return new String(Files.readAllBytes(Paths.get(file.toURI())));
    }

    public static JSONObject toJSONObject(String url) throws Exception {
        return JenkinsResultsParserUtil.toJSONObject(url, true, 0);
    }

    public static JSONObject toJSONObject(String url, boolean checkCache) throws Exception {
        return JenkinsResultsParserUtil.createJSONObject(JenkinsResultsParserUtil.toString(url, checkCache, 0));
    }

    public static JSONObject toJSONObject(String url, boolean checkCache, int timeout) throws Exception {
        return JenkinsResultsParserUtil.createJSONObject(JenkinsResultsParserUtil.toString(url, checkCache, timeout));
    }

    public static String toString(String url) throws Exception {
        return JenkinsResultsParserUtil.toString(url, true, 0);
    }

    public static String toString(String url, boolean checkCache) throws Exception {
        return JenkinsResultsParserUtil.toString(url, checkCache, 0);
    }

    public static String toString(String url, boolean checkCache, int timeout) throws Exception {
        url = JenkinsResultsParserUtil.fixURL(url);
        String key = url.replace("//", "/");
        if (checkCache && _toStringCache.containsKey(key) && !url.startsWith("file:")) {
            System.out.println("Loading " + url);
            return _toStringCache.get(key);
        }
        int retryCount = 0;
        while (true) {
            try {
                System.out.println("Downloading " + url);
                StringBuilder sb = new StringBuilder();
                URL urlObject = new URL(url);
                URLConnection urlConnection = urlObject.openConnection();
                if (timeout != 0) {
                    urlConnection.setConnectTimeout(timeout);
                    urlConnection.setReadTimeout(timeout);
                }
                InputStreamReader inputStreamReader = new InputStreamReader(urlConnection.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
                bufferedReader.close();
                if (!url.startsWith("file:")) {
                    _toStringCache.put(key, sb.toString());
                }
                return sb.toString();
            }
            catch (FileNotFoundException fnfe) {
                if (++retryCount > 3) {
                    throw fnfe;
                }
                System.out.println("Retry in 5 seconds");
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
    }

    public static void write(File file, String content) throws IOException {
        System.out.println("Write file " + file + " with length " + content.length());
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            System.out.println("Make parent directories for " + file);
            parentDir.mkdirs();
        }
        Files.write(Paths.get(file.toURI()), content.getBytes(), new OpenOption[0]);
    }
}

