/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class JenkinsStopJobUtil {
    private static final Pattern _jobNamePattern = Pattern.compile(".+://(?<hostName>[^.]+).liferay.com/job/(?<jobName>[^/]+).*/(?<buildNumber>\\d+)/");
    private static final Pattern _progressiveTextPattern = Pattern.compile("\\[echo\\] Build \\'.*\\' started at (?<url>.+)\\.");

    public static void stopJenkinsJob(String jobURL, String username, String password) throws Exception {
        JenkinsStopJobUtil.stopJob(jobURL, username, password);
        JenkinsStopJobUtil.stopDownstreamJobs(jobURL, username, password);
    }

    protected static String encodeAuthorizationFields(String username, String password) {
        String authorizationString = username + ":" + password;
        return new String(Base64.encodeBase64((byte[])authorizationString.getBytes()));
    }

    private static List<String> getDownstreamURLs(String jobURL) throws Exception {
        ArrayList<String> downstreamURLs = new ArrayList<String>();
        String consoleOutput = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(jobURL + "/logText/progressiveText"));
        Matcher progressiveTextMatcher = _progressiveTextPattern.matcher(consoleOutput);
        while (progressiveTextMatcher.find()) {
            String urlString = progressiveTextMatcher.group("url");
            Matcher jobNameMatcher = _jobNamePattern.matcher(urlString);
            if (!jobNameMatcher.find()) continue;
            downstreamURLs.add(urlString);
        }
        return downstreamURLs;
    }

    private static void stopDownstreamJobs(String jobURL, String username, String password) throws Exception {
        List<String> downstreamURLs = JenkinsStopJobUtil.getDownstreamURLs(jobURL);
        for (String downstreamURL : downstreamURLs) {
            JenkinsStopJobUtil.stopJob(downstreamURL, username, password);
        }
    }

    private static void stopJob(String jobURL, String username, String password) throws Exception {
        URL urlObject = new URL(JenkinsResultsParserUtil.fixURL(JenkinsResultsParserUtil.getLocalURL(jobURL + "/stop")));
        HttpURLConnection httpConnection = (HttpURLConnection)urlObject.openConnection();
        httpConnection.setRequestMethod("POST");
        httpConnection.setRequestProperty("Authorization", "Basic " + JenkinsStopJobUtil.encodeAuthorizationFields(username, password));
        System.out.println("Response from " + jobURL + "/stop: " + httpConnection.getResponseCode() + " " + httpConnection.getResponseMessage());
    }
}

