/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import org.apache.tools.ant.Project;
import org.json.JSONObject;

public class PluginFailureMessageGenerator
extends BaseFailureMessageGenerator {
    @Override
    public String getMessage(String buildURL, String consoleOutput, Project project) throws Exception {
        if (!buildURL.contains("portal-acceptance")) {
            return null;
        }
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildURL + "api/json"));
        String jobVariant = JenkinsResultsParserUtil.getJobVariant(jsonObject);
        if (!buildURL.contains("plugins") && !jobVariant.contains("plugins")) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>To include a plugin fix for this pull request, ");
        sb.append("please edit your <a href=\"https://github.com/");
        sb.append(project.getProperty("github.pull.request.head.username"));
        sb.append("/");
        sb.append(project.getProperty("portal.repository"));
        sb.append("/blob/");
        sb.append(project.getProperty("github.pull.request.head.branch"));
        sb.append("/git-commit-plugins\">git-commit-plugins</a>. ");
        sb.append("Click <a href=\"https://in.liferay.com/web/");
        sb.append("global.engineering/blog/-/blogs/new-tests-for-the-pull-");
        sb.append("request-tester-\">here</a> for more details.</p>");
        int end = consoleOutput.indexOf("merge-test-results:");
        sb.append(this.getConsoleOutputSnippet(consoleOutput, end));
        return sb.toString();
    }
}

