/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class UnstableMessageUtil {
    public static String getUnstableMessage(String buildURL) throws Exception {
        StringBuilder sb = new StringBuilder();
        JSONObject testReportJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildURL + "testReport/api/json"));
        int failCount = testReportJSONObject.getInt("failCount");
        int totalCount = testReportJSONObject.getInt("totalCount");
        int passCount = totalCount - failCount;
        sb.append("<h6>Job Results:</h6>");
        sb.append("<p>");
        sb.append(passCount);
        sb.append(" Test");
        if (passCount != 1) {
            sb.append("s");
        }
        sb.append(" Passed.<br />");
        sb.append(failCount);
        sb.append(" Test");
        if (failCount != 1) {
            sb.append("s");
        }
        sb.append(" Failed.</p>");
        sb.append("<ol>");
        ArrayList<String> runBuildURLs = new ArrayList<String>();
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildURL + "api/json"));
        if (jsonObject.has("runs")) {
            JSONArray runsJSONArray = jsonObject.getJSONArray("runs");
            for (int i = 0; i < runsJSONArray.length(); ++i) {
                JSONObject runBuildURLJSONObject;
                String result;
                JSONObject runJSONObject = runsJSONArray.getJSONObject(i);
                String runBuildURL = runJSONObject.getString("url");
                if (!runBuildURL.endsWith("/" + jsonObject.getInt("number") + "/") || (result = (runBuildURLJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(runBuildURL + "api/json"))).getString("result")).equals("SUCCESS")) continue;
                runBuildURLs.add(runBuildURL);
            }
        } else {
            runBuildURLs.add(buildURL);
        }
        int failureCount = UnstableMessageUtil._getUnstableMessage(sb, runBuildURLs);
        sb.append("</ol>");
        if (failureCount > 3) {
            sb.append("<p><strong>Click <a href=\"");
            sb.append(buildURL);
            sb.append("/testReport/\">here</a> for more failures.</strong>");
            sb.append("</p>");
        }
        return sb.toString();
    }

    private static int _getUnstableMessage(StringBuilder sb, List<String> runBuildURLs) throws Exception {
        int failureCount = 0;
        for (String runBuildURL : runBuildURLs) {
            JSONObject testReportJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(runBuildURL + "testReport/api/json"));
            JSONArray suitesJSONArray = testReportJSONObject.getJSONArray("suites");
            for (int i = 0; i < suitesJSONArray.length(); ++i) {
                JSONObject suiteJSONObject = suitesJSONArray.getJSONObject(i);
                JSONArray casesJSONArray = suiteJSONObject.getJSONArray("cases");
                for (int j = 0; j < casesJSONArray.length(); ++j) {
                    String testMethodName;
                    JSONObject caseJSONObject = casesJSONArray.getJSONObject(j);
                    String status = caseJSONObject.getString("status");
                    if (status.equals("FIXED") || status.equals("PASSED") || status.equals("SKIPPED")) continue;
                    if (failureCount == 3) {
                        sb.append("<li>...</li>");
                        return ++failureCount;
                    }
                    sb.append("<li><a href=\"");
                    String runBuildHREF = runBuildURL;
                    runBuildHREF = runBuildHREF.replace("[", "_");
                    runBuildHREF = runBuildHREF.replace("]", "_");
                    runBuildHREF = runBuildHREF.replace("#", "_");
                    sb.append(runBuildHREF);
                    sb.append("/testReport/");
                    String testClassName = caseJSONObject.getString("className");
                    int x = testClassName.lastIndexOf(".");
                    String testPackageName = testClassName.substring(0, x);
                    sb.append(testPackageName);
                    sb.append("/");
                    String testSimpleClassName = testClassName.substring(x + 1);
                    sb.append(testSimpleClassName);
                    sb.append("/");
                    String testMethodNameURL = testMethodName = caseJSONObject.getString("name");
                    testMethodNameURL = testMethodNameURL.replace("[", "_");
                    testMethodNameURL = testMethodNameURL.replace("]", "_");
                    testMethodNameURL = testMethodNameURL.replace("#", "_");
                    if (testPackageName.equals("junit.framework")) {
                        testMethodNameURL = testMethodNameURL.replace(".", "_");
                    }
                    sb.append(testMethodNameURL);
                    sb.append("\">");
                    sb.append(testSimpleClassName);
                    sb.append(".");
                    sb.append(testMethodName);
                    JSONObject runBuildURLJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(runBuildURL + "api/json"));
                    String jobVariant = JenkinsResultsParserUtil.getJobVariant(runBuildURLJSONObject);
                    if (jobVariant.contains("functional") && testClassName.contains("EvaluateLogTest")) {
                        sb.append("[");
                        sb.append(JenkinsResultsParserUtil.getAxisVariable(runBuildURLJSONObject));
                        sb.append("]");
                    }
                    sb.append("</a>");
                    if (jobVariant.contains("functional")) {
                        sb.append(" - ");
                        String description = runBuildURLJSONObject.getString("description");
                        x = description.indexOf(">Jenkins Report<") + 22;
                        if (description.length() > x) {
                            description = description.substring(x);
                            description = description.replace("\"", "\"");
                            sb.append(description);
                            sb.append(" - ");
                        }
                        sb.append("<a href=\"");
                        sb.append(runBuildURL);
                        sb.append("/console\">Console Output</a>");
                    }
                    sb.append("</li>");
                    ++failureCount;
                }
            }
        }
        return failureCount;
    }
}

